/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

class Base2ExponentialHistogramIndexer {
    private static final long EXPONENT_BIT_MASK = 0x7FF0000000000000L;
    private static final long SIGNIFICAND_BIT_MASK = 0xFFFFFFFFFFFFFL;
    private static final int EXPONENT_BIAS = 1023;
    private static final int SIGNIFICAND_WIDTH = 52;
    private static final int EXPONENT_WIDTH = 11;
    private static final double LOG_BASE2_E = 1.0 / Math.log(2.0);

    Base2ExponentialHistogramIndexer() {
    }

    static long computeIndex(double value, int scale) {
        double absValue = Math.abs(value);
        if (scale > 0) {
            return Base2ExponentialHistogramIndexer.getIndexByLogarithm(absValue, scale);
        }
        if (scale == 0) {
            return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(absValue);
        }
        return Base2ExponentialHistogramIndexer.mapToIndexScaleZero(absValue) >> -scale;
    }

    private static long getIndexByLogarithm(double value, int scale) {
        return (long)Math.ceil(Math.scalb(Math.log(value) * LOG_BASE2_E, scale)) - 1L;
    }

    private static long mapToIndexScaleZero(double value) {
        long rawBits = Double.doubleToLongBits(value);
        long rawExponent = (rawBits & 0x7FF0000000000000L) >> 52;
        long rawSignificand = rawBits & 0xFFFFFFFFFFFFFL;
        if (rawExponent == 0L) {
            rawExponent -= (long)(Long.numberOfLeadingZeros(rawSignificand - 1L) - 11 - 1);
        }
        int ieeeExponent = (int)(rawExponent - 1023L);
        if (rawSignificand == 0L) {
            return ieeeExponent - 1;
        }
        return ieeeExponent;
    }
}

