/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.SubmitAsyncSearchRequest;
import org.elasticsearch.xpack.search.AsyncSearchTask;

public class TransportSubmitAsyncSearchAction
extends HandledTransportAction<SubmitAsyncSearchRequest, AsyncSearchResponse> {
    private final ClusterService clusterService;
    private final NodeClient nodeClient;
    private final SearchService searchService;
    private final TransportSearchAction searchAction;
    private final ThreadContext threadContext;
    private final AsyncTaskIndexService<AsyncSearchResponse> store;

    @Inject
    public TransportSubmitAsyncSearchAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NamedWriteableRegistry registry, Client client, NodeClient nodeClient, SearchService searchService, TransportSearchAction searchAction, BigArrays bigArrays) {
        super("indices:data/read/async_search/submit", transportService, actionFilters, SubmitAsyncSearchRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.nodeClient = nodeClient;
        this.searchService = searchService;
        this.searchAction = searchAction;
        this.threadContext = transportService.getThreadPool().getThreadContext();
        this.store = new AsyncTaskIndexService(".async-search", clusterService, this.threadContext, client, "async_search", AsyncSearchResponse::new, registry, bigArrays);
    }

    protected void doExecute(Task submitTask, final SubmitAsyncSearchRequest request, ActionListener<AsyncSearchResponse> submitListener) {
        SearchRequest searchRequest = this.createSearchRequest(request, submitTask, request.getKeepAlive());
        try (ThreadContext.StoredContext ignored = this.threadContext.newTraceContext();){
            final AsyncSearchTask searchTask = (AsyncSearchTask)this.taskManager.register("transport", TransportSearchAction.TYPE.name(), (TaskAwareRequest)searchRequest);
            this.searchAction.execute((Task)searchTask, (ActionRequest)searchRequest, (ActionListener)searchTask.getSearchProgressActionListener());
            final ActionListener submitListenerWithHeaders = submitListener.map(response -> {
                this.threadContext.addResponseHeader("X-Elasticsearch-Async-Is-Running", response.isRunning() ? "?1" : "?0");
                if (response.getId() != null) {
                    this.threadContext.addResponseHeader("X-Elasticsearch-Async-Id", response.getId());
                }
                return response;
            });
            searchTask.addCompletionListener(new ActionListener<AsyncSearchResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(final AsyncSearchResponse searchResponse) {
                    if (searchResponse.isRunning() || request.isKeepOnCompletion()) {
                        try {
                            String docId = searchTask.getExecutionId().getDocId();
                            AsyncSearchResponse initialResp = searchResponse.clone(searchResponse.getId());
                            searchResponse.mustIncRef();
                            try {
                                TransportSubmitAsyncSearchAction.this.store.createResponse(docId, searchTask.getOriginHeaders(), (AsyncResponse)initialResp, ActionListener.runAfter((ActionListener)new ActionListener<DocWriteResponse>(){

                                    public void onResponse(DocWriteResponse r) {
                                        if (searchResponse.isRunning()) {
                                            try {
                                                searchTask.addCompletionListener(finalResponse -> TransportSubmitAsyncSearchAction.this.onFinalResponse(searchTask, (AsyncSearchResponse)finalResponse, () -> {}));
                                            }
                                            finally {
                                                submitListenerWithHeaders.onResponse((Object)searchResponse);
                                            }
                                        } else {
                                            searchResponse.mustIncRef();
                                            TransportSubmitAsyncSearchAction.this.onFinalResponse(searchTask, searchResponse, () -> ActionListener.respondAndRelease((ActionListener)submitListenerWithHeaders, (RefCounted)searchResponse));
                                        }
                                    }

                                    public void onFailure(Exception exc) {
                                        TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, searchResponse.isRunning(), "fatal failure: unable to store initial response", (ActionListener<AsyncSearchResponse>)submitListenerWithHeaders);
                                    }
                                }, () -> ((AsyncSearchResponse)searchResponse).decRef()));
                            }
                            finally {
                                initialResp.decRef();
                            }
                        }
                        catch (Exception exc) {
                            TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, searchResponse.isRunning(), "fatal failure: generic error", (ActionListener<AsyncSearchResponse>)submitListenerWithHeaders);
                        }
                    } else {
                        try (AsyncSearchTask asyncSearchTask = searchTask;){
                            TransportSubmitAsyncSearchAction.this.taskManager.unregister((Task)searchTask);
                            ActionListener.respondAndRelease((ActionListener)submitListenerWithHeaders, (RefCounted)searchResponse.clone(null));
                        }
                    }
                }

                public void onFailure(Exception exc) {
                    TransportSubmitAsyncSearchAction.this.onFatalFailure(searchTask, exc, true, "fatal failure: addCompletionListener", (ActionListener<AsyncSearchResponse>)submitListenerWithHeaders);
                }
            }, request.getWaitForCompletionTimeout());
        }
    }

    private SearchRequest createSearchRequest(SubmitAsyncSearchRequest request, Task submitTask, final TimeValue keepAlive) {
        final String docID = UUIDs.randomBase64UUID();
        final Map originHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.nodeClient.threadPool().getThreadContext(), (ClusterState)this.clusterService.state());
        final SearchRequest originalSearchRequest = request.getSearchRequest();
        SearchRequest searchRequest = new SearchRequest(originalSearchRequest){

            public AsyncSearchTask createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> taskHeaders) {
                AsyncExecutionId searchId = new AsyncExecutionId(docID, new TaskId(TransportSubmitAsyncSearchAction.this.nodeClient.getLocalNodeId(), id));
                return new AsyncSearchTask(id, type, action, parentTaskId, () -> (this).buildDescription(), keepAlive, originHeaders, taskHeaders, searchId, TransportSubmitAsyncSearchAction.this.store.getClientWithOrigin(), TransportSubmitAsyncSearchAction.this.nodeClient.threadPool(), isCancelled -> () -> this.lambda$createTask$0((Supplier)isCancelled, originalSearchRequest), TransportSubmitAsyncSearchAction.this.store);
            }

            private /* synthetic */ AggregationReduceContext lambda$createTask$0(Supplier isCancelled, SearchRequest originalSearchRequest2) {
                return TransportSubmitAsyncSearchAction.this.searchService.aggReduceContextBuilder(isCancelled, originalSearchRequest2.source().aggregations()).forFinalReduction();
            }
        };
        searchRequest.setParentTask(new TaskId(this.nodeClient.getLocalNodeId(), submitTask.getId()));
        return searchRequest;
    }

    private void onFatalFailure(AsyncSearchTask task, Exception error, boolean shouldCancel, String cancelReason, ActionListener<AsyncSearchResponse> listener) {
        if (shouldCancel && !task.isCancelled()) {
            task.cancelTask(() -> this.closeTaskAndFail(task, error, listener), cancelReason);
        } else {
            this.closeTaskAndFail(task, error, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTaskAndFail(AsyncSearchTask task, Exception error, ActionListener<AsyncSearchResponse> listener) {
        try {
            task.addCompletionListener(finalResponse -> {
                try (AsyncSearchTask asyncSearchTask = task;){
                    this.taskManager.unregister((Task)task);
                }
            });
        }
        finally {
            listener.onFailure(error);
        }
    }

    private void onFinalResponse(AsyncSearchTask searchTask, AsyncSearchResponse response, Runnable nextAction) {
        this.store.updateResponse(searchTask.getExecutionId().getDocId(), this.threadContext.getResponseHeaders(), (AsyncResponse)response, ActionListener.running(() -> {
            try (AsyncSearchTask asyncSearchTask = searchTask;){
                this.taskManager.unregister((Task)searchTask);
            }
            nextAction.run();
        }));
    }
}

