/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.profile;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesAction;
import org.elasticsearch.xpack.core.security.action.profile.GetProfilesRequest;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetProfilesAction
extends SecurityBaseRestHandler {
    public RestGetProfilesAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_security/profile/{uid}"));
    }

    public String getName() {
        return "xpack_security_get_profile";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] uids = request.paramAsStringArray("uid", Strings.EMPTY_ARRAY);
        Set dataKeys = Strings.tokenizeByCommaToSet((String)request.param("data", null));
        GetProfilesRequest getProfilesRequest = new GetProfilesRequest(Arrays.asList(uids), dataKeys);
        return channel -> client.execute((ActionType)GetProfilesAction.INSTANCE, (ActionRequest)getProfilesRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

