/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support.search;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;

public class WatcherSearchTemplateService {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final Predicate<NodeFeature> clusterSupportsFeature;

    public WatcherSearchTemplateService(ScriptService scriptService, NamedXContentRegistry xContentRegistry, Predicate<NodeFeature> clusterSupportsFeature) {
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.clusterSupportsFeature = clusterSupportsFeature;
    }

    public String renderTemplate(Script source, WatchExecutionContext ctx, Payload payload) {
        Map<String, Object> watcherContextParams = Variables.createCtxParamsMap(ctx, payload);
        if (source.getParams() != null) {
            watcherContextParams.putAll(source.getParams());
        }
        Script template = new Script(source.getType(), source.getType() == ScriptType.STORED ? null : "mustache", source.getIdOrCode(), source.getOptions(), watcherContextParams);
        TemplateScript.Factory compiledTemplate = (TemplateScript.Factory)this.scriptService.compile(template, Watcher.SCRIPT_TEMPLATE_CONTEXT);
        return compiledTemplate.newInstance(template.getParams()).execute();
    }

    public SearchRequest toSearchRequest(WatcherSearchTemplateRequest request) throws IOException {
        SearchRequest searchRequest = new SearchRequest(request.getIndices());
        searchRequest.searchType(request.getSearchType());
        searchRequest.indicesOptions(request.getIndicesOptions());
        SearchSourceBuilder sourceBuilder = SearchSourceBuilder.searchSource();
        BytesReference source = request.getSearchSource();
        if (source != null && source.length() > 0) {
            try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG.withRegistry(this.xContentRegistry), (BytesReference)source, (XContentType)XContentHelper.xContentType((BytesReference)source));){
                sourceBuilder.parseXContent(parser, true, this.clusterSupportsFeature);
                searchRequest.source(sourceBuilder);
            }
        }
        return searchRequest;
    }
}

