/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.proto;

import com.google.protobuf.ByteString;
import java.io.IOException;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.xcontent.XContentBuilder;

public class BufferedByteStringAccessor {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    private byte[] bytes = new byte[128];

    public void addStringDimension(TsidBuilder tsidBuilder, String dimension, ByteString value) {
        if (value.isEmpty()) {
            return;
        }
        tsidBuilder.addStringDimension(dimension, this.toBytes(value), 0, value.size());
    }

    public void utf8Value(XContentBuilder builder, ByteString value) throws IOException {
        builder.utf8Value(this.toBytes(value), 0, value.size());
    }

    private byte[] toBytes(ByteString byteString) {
        int size = byteString.size();
        if (this.bytes.length < size) {
            this.bytes = new byte[size];
        }
        byteString.copyTo(this.bytes, 0);
        return this.bytes;
    }
}

