/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.settings;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.security.action.ActionTypes;

public class TransportReloadRemoteClusterCredentialsAction
extends TransportAction<Request, ActionResponse.Empty> {
    private final RemoteClusterService remoteClusterService;
    private final ClusterService clusterService;

    @Inject
    public TransportReloadRemoteClusterCredentialsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters) {
        super(ActionTypes.RELOAD_REMOTE_CLUSTER_CREDENTIALS_ACTION.name(), actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.remoteClusterService = transportService.getRemoteClusterService();
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, Request request, ActionListener<ActionResponse.Empty> listener) {
        assert (Transports.assertNotTransportThread((String)"Remote connection re-building is too much for a transport thread"));
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException clusterBlockException = this.checkBlock(clusterState);
        if (clusterBlockException != null) {
            throw clusterBlockException;
        }
        Supplier<Settings> settingsSupplier = () -> {
            Settings persistentSettings = clusterState.metadata().persistentSettings();
            Settings transientSettings = clusterState.metadata().transientSettings();
            return Settings.builder().put(request.getSettings(), true).put(persistentSettings, false).put(transientSettings, false).build();
        };
        this.remoteClusterService.updateRemoteClusterCredentials(settingsSupplier, listener.safeMap(ignored -> ActionResponse.Empty.INSTANCE));
    }

    private ClusterBlockException checkBlock(ClusterState clusterState) {
        return clusterState.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Request
    extends LegacyActionRequest {
        private final Settings settings;

        public Request(Settings settings) {
            this.settings = settings;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }
    }
}

