/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.blobcache.BlobCacheUtils;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.index.StandardIOBehaviorHint;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheFile;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.MetadataCachingIndexInput;

public class CachedBlobContainerIndexInput
extends MetadataCachingIndexInput {
    public static final IOContext CACHE_WARMING_CONTEXT = IOContext.DEFAULT.withHints(new IOContext.FileOpenHint[]{StandardIOBehaviorHint.INSTANCE});
    private static final Logger logger = LogManager.getLogger(CachedBlobContainerIndexInput.class);

    public CachedBlobContainerIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, int rangeSize, int recoveryRangeSize) {
        this(name, directory, fileInfo, context, stats, 0L, 0L, fileInfo.length(), new MetadataCachingIndexInput.CacheFileReference(directory, fileInfo.physicalName(), fileInfo.length()), rangeSize, recoveryRangeSize, directory.getBlobCacheByteRange(name, fileInfo.length()), ByteRange.EMPTY);
        stats.incrementOpenCount();
    }

    private CachedBlobContainerIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, MetadataCachingIndexInput.CacheFileReference cacheFileReference, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(logger, name, directory, fileInfo, context, stats, offset, compoundFileOffset, length, cacheFileReference, defaultRangeSize, recoveryRangeSize, headerBlobCacheByteRange, footerBlobCacheByteRange);
    }

    @Override
    protected void readWithoutBlobCache(ByteBuffer b) throws Exception {
        this.ensureContext(ctx -> !ctx.hints().contains(StandardIOBehaviorHint.INSTANCE));
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        CacheFile cacheFile = this.cacheFileReference.get();
        ByteRange rangeToWrite = BlobCacheUtils.computeRange((long)(this.directory.isRecoveryFinalized() ? (long)this.defaultRangeSize : (long)this.recoveryRangeSize), (long)position, (long)length, (long)this.fileInfo.length());
        ByteRange rangeToRead = ByteRange.of((long)position, (long)(position + (long)length));
        assert (rangeToRead.isSubRangeOf(rangeToWrite)) : String.valueOf(rangeToRead) + " vs " + String.valueOf(rangeToWrite);
        assert (rangeToRead.length() == (long)b.remaining()) : b.remaining() + " vs " + String.valueOf(rangeToRead);
        int bytesRead = this.populateAndRead(b, position, cacheFile, rangeToWrite).get();
        assert (bytesRead == length) : bytesRead + " vs " + length;
    }

    public long getPersistentCacheInitialLength() throws Exception {
        return this.cacheFileReference.get().getInitialLength();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long prefetchPart(int part, Supplier<Boolean> isCancelled) throws IOException {
        ByteRange partRange;
        this.ensureContext(ctx -> ctx.hints().contains(StandardIOBehaviorHint.INSTANCE));
        if (part >= this.fileInfo.numberOfParts()) {
            throw new IllegalArgumentException("Unexpected part number [" + part + "]");
        }
        if (isCancelled.get().booleanValue()) {
            return -1L;
        }
        if (this.fileInfo.numberOfParts() == 1) {
            partRange = ByteRange.of((long)0L, (long)this.fileInfo.length());
        } else {
            long rangeSize = this.fileInfo.partSize().getBytes();
            long rangeStart = IntStream.range(0, part).mapToLong(arg_0 -> ((BlobStoreIndexShardSnapshot.FileInfo)this.fileInfo).partBytes(arg_0)).sum() / rangeSize * rangeSize;
            partRange = ByteRange.of((long)rangeStart, (long)Math.min(rangeStart + rangeSize, this.fileInfo.length()));
        }
        assert (this.assertRangeIsAlignedWithPart(partRange));
        try {
            CacheFile cacheFile = this.cacheFileReference.get();
            ByteRange range = cacheFile.getAbsentRangeWithin(partRange);
            if (range == null) {
                logger.trace("prefetchPart: part [{}] bytes [{}-{}] is already fully available for cache file [{}]", (Object)part, (Object)partRange.start(), (Object)partRange.end(), (Object)this.cacheFileReference);
                return 0L;
            }
            logger.trace("prefetchPart: prewarming part [{}] bytes [{}-{}] by fetching bytes [{}-{}] for cache file [{}]", (Object)part, (Object)partRange.start(), (Object)partRange.end(), (Object)range.start(), (Object)range.end(), (Object)this.cacheFileReference);
            ByteBuffer copyBuffer = (ByteBuffer)writeBuffer.get();
            long totalBytesRead = 0L;
            AtomicLong totalBytesWritten = new AtomicLong();
            long startTimeNanos = this.stats.currentTimeNanos();
            try (InputStream input = this.openInputStreamFromBlobStore(range.start(), range.length());){
                int bytesRead;
                for (long remainingBytes = range.length(); remainingBytes > 0L; totalBytesRead += (long)bytesRead, remainingBytes -= (long)bytesRead) {
                    ByteRange rangeToWrite;
                    assert (totalBytesRead + remainingBytes == range.length());
                    copyBuffer.clear();
                    if (isCancelled.get().booleanValue()) {
                        long l = -1L;
                        return l;
                    }
                    bytesRead = BlobCacheUtils.readSafe((InputStream)input, (ByteBuffer)copyBuffer, (long)range.start(), (long)remainingBytes);
                    long readStart = range.start() + totalBytesRead;
                    ByteRange rangeToRead = rangeToWrite = ByteRange.of((long)readStart, (long)(readStart + (long)bytesRead));
                    cacheFile.populateAndRead(rangeToWrite, rangeToRead, channel -> bytesRead, (channel, start, end, progressUpdater) -> {
                        int writtenBytes = CachedBlobContainerIndexInput.positionalWrite(channel, start, copyBuffer.slice(BlobCacheUtils.toIntBytes((long)(start - readStart)), BlobCacheUtils.toIntBytes((long)(end - start))));
                        logger.trace("prefetchPart: writing range [{}-{}] of file [{}], [{}] bytes written", (Object)start, (Object)end, (Object)this.fileInfo.physicalName(), (Object)writtenBytes);
                        totalBytesWritten.addAndGet(writtenBytes);
                        progressUpdater.accept(start + (long)writtenBytes);
                    }, this.directory.cacheFetchAsyncExecutor()).get();
                }
                long endTimeNanos = this.stats.currentTimeNanos();
                this.stats.addCachedBytesWritten(totalBytesWritten.get(), endTimeNanos - startTimeNanos);
            }
            if ($assertionsDisabled) return totalBytesRead;
            if (totalBytesRead == range.length()) return totalBytesRead;
            throw new AssertionError();
        }
        catch (Exception e) {
            throw new IOException("Failed to prefetch file part in cache", e);
        }
    }

    private boolean assertRangeIsAlignedWithPart(ByteRange range) {
        if ((long)this.fileInfo.numberOfParts() == 1L) {
            long length = this.fileInfo.length();
            assert (range.start() == 0L) : "start of range [" + range.start() + "] is not aligned with zero";
            assert (range.end() == length) : "end of range [" + range.end() + "] is not aligned with file length [" + length + "]";
        } else {
            long length = this.fileInfo.partSize().getBytes();
            assert (range.start() % length == 0L) : "start of range [" + range.start() + "] is not aligned with part start";
            assert (range.end() % length == 0L || range.end() == this.fileInfo.length()) : "end of range [" + range.end() + "] is not aligned with part end or with file length";
        }
        return true;
    }

    private void ensureContext(Predicate<IOContext> predicate) throws IOException {
        if (!predicate.test(this.context)) {
            assert (false) : "this method should not be used with this context " + String.valueOf(this.context);
            throw new IOException("Cannot read the index input using context [context=" + String.valueOf(this.context) + ", input=" + String.valueOf((Object)this) + "]");
        }
    }

    @Override
    protected MetadataCachingIndexInput doSlice(String sliceName, long sliceOffset, long sliceLength, ByteRange sliceHeaderByteRange, ByteRange sliceFooterByteRange, long sliceCompoundFileOffset) {
        return new CachedBlobContainerIndexInput(sliceName, this.directory, this.fileInfo, this.context, this.stats, sliceOffset, sliceCompoundFileOffset, sliceLength, this.cacheFileReference, this.defaultRangeSize, this.recoveryRangeSize, sliceHeaderByteRange, sliceFooterByteRange);
    }

    @Override
    public String toString() {
        CacheFile cacheFile = this.cacheFileReference.cacheFile.get();
        return super.toString() + "[cache file=" + (cacheFile != null ? String.join((CharSequence)"/", this.directory.getShardId().getIndex().getUUID(), String.valueOf(this.directory.getShardId().getId()), "snapshot_cache", this.directory.getSnapshotId().getUUID(), cacheFile.getFile().getFileName().toString()) : null) + "]";
    }
}

