/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.LinkedProjectConfigService;

public abstract class AbstractLinkedProjectConfigService
implements LinkedProjectConfigService {
    private final List<LinkedProjectConfigService.LinkedProjectConfigListener> listeners = new CopyOnWriteArrayList<LinkedProjectConfigService.LinkedProjectConfigListener>();

    @Override
    public void register(LinkedProjectConfigService.LinkedProjectConfigListener listener) {
        this.listeners.add(listener);
    }

    protected void handleUpdate(LinkedProjectConfig config) {
        this.listeners.forEach(listener -> listener.updateLinkedProject(config));
    }

    protected void handleSkipUnavailableChanged(ProjectId originProjectId, ProjectId linkedProjectId, String linkedProjectAlias, boolean skipUnavailable) {
        this.listeners.forEach(listener -> listener.skipUnavailableChanged(originProjectId, linkedProjectId, linkedProjectAlias, skipUnavailable));
    }
}

