/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.index.mapper.IgnoredFieldsSpec;

public record StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields, IgnoredFieldsSpec ignoredFieldsSpec) {
    private final Set<String> requiredStoredFields;
    public static final StoredFieldsSpec NO_REQUIREMENTS = new StoredFieldsSpec(false, false, Set.of());
    public static final StoredFieldsSpec NEEDS_SOURCE = new StoredFieldsSpec(true, false, Set.of());

    public StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields) {
        this(requiresSource, requiresMetadata, requiredStoredFields, IgnoredFieldsSpec.NONE);
    }

    public boolean noRequirements() {
        return !this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty() && this.ignoredFieldsSpec.noRequirements();
    }

    public boolean onlyRequiresIgnoredFields() {
        return !this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty() && !this.ignoredFieldsSpec.noRequirements();
    }

    public StoredFieldsSpec merge(StoredFieldsSpec other) {
        Set<String> mergedFields;
        if (this == other) {
            return this;
        }
        if (other.requiredStoredFields.isEmpty()) {
            mergedFields = this.requiredStoredFields;
        } else {
            mergedFields = new HashSet<String>(this.requiredStoredFields);
            mergedFields.addAll(other.requiredStoredFields);
        }
        return new StoredFieldsSpec(this.requiresSource || other.requiresSource, this.requiresMetadata || other.requiresMetadata, mergedFields, this.ignoredFieldsSpec.merge(other.ignoredFieldsSpec));
    }

    public Set<String> requiredStoredFields() {
        if (this.ignoredFieldsSpec.noRequirements()) {
            return this.requiredStoredFields;
        }
        if (this.requiredStoredFields.isEmpty()) {
            return this.ignoredFieldsSpec.requiredStoredFields();
        }
        HashSet<String> mergedFields = new HashSet<String>(this.requiredStoredFields);
        mergedFields.addAll(this.ignoredFieldsSpec.requiredStoredFields());
        return mergedFields;
    }

    public static <T> StoredFieldsSpec build(Collection<T> sources, Function<T, StoredFieldsSpec> converter) {
        StoredFieldsSpec storedFieldsSpec = NO_REQUIREMENTS;
        for (T source : sources) {
            storedFieldsSpec = storedFieldsSpec.merge(converter.apply(source));
        }
        return storedFieldsSpec;
    }
}

