/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.metrics.HDRPercentileRanksAggregator;
import org.elasticsearch.search.aggregations.metrics.HDRPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestPercentileRanksAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestPercentilesAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class PercentilesConfig
implements ToXContent,
Writeable {
    private final PercentilesMethod method;

    public static int indexOfKey(double[] keys, double key) {
        return ArrayUtils.binarySearch(keys, key, 0.001);
    }

    PercentilesConfig(PercentilesMethod method) {
        this.method = method;
    }

    public static PercentilesConfig fromStream(StreamInput in) throws IOException {
        PercentilesMethod method = PercentilesMethod.readFromStream(in);
        return method.configFromStream(in);
    }

    public PercentilesMethod getMethod() {
        return this.method;
    }

    public abstract Aggregator createPercentilesAggregator(String var1, ValuesSourceConfig var2, AggregationContext var3, Aggregator var4, double[] var5, boolean var6, DocValueFormat var7, Map<String, Object> var8) throws IOException;

    public abstract InternalNumericMetricsAggregation.MultiValue createEmptyPercentilesAggregator(String var1, double[] var2, boolean var3, DocValueFormat var4, Map<String, Object> var5);

    abstract Aggregator createPercentileRanksAggregator(String var1, ValuesSourceConfig var2, AggregationContext var3, Aggregator var4, double[] var5, boolean var6, DocValueFormat var7, Map<String, Object> var8) throws IOException;

    public abstract InternalNumericMetricsAggregation.MultiValue createEmptyPercentileRanksAggregator(String var1, double[] var2, boolean var3, DocValueFormat var4, Map<String, Object> var5);

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PercentilesConfig other = (PercentilesConfig)obj;
        return this.method.equals(other.getMethod());
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public static final class Hdr
    extends PercentilesConfig {
        static final int DEFAULT_NUMBER_SIG_FIGS = 3;
        private int numberOfSignificantValueDigits;

        public Hdr() {
            this(3);
        }

        public Hdr(int numberOfSignificantValueDigits) {
            super(PercentilesMethod.HDR);
            this.setNumberOfSignificantValueDigits(numberOfSignificantValueDigits);
        }

        Hdr(StreamInput in) throws IOException {
            this(in.readVInt());
        }

        public void setNumberOfSignificantValueDigits(int numberOfSignificantValueDigits) {
            if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
                throw new IllegalArgumentException("[numberOfSignificantValueDigits] must be between 0 and 5");
            }
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        }

        public int getNumberOfSignificantValueDigits() {
            return this.numberOfSignificantValueDigits;
        }

        @Override
        public Aggregator createPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new HDRPercentilesAggregator(name, config, context, parent, values, this.numberOfSignificantValueDigits, keyed, formatter, metadata);
        }

        @Override
        public InternalNumericMetricsAggregation.MultiValue createEmptyPercentilesAggregator(String name, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
            return InternalHDRPercentiles.empty(name, values, keyed, formatter, metadata);
        }

        @Override
        Aggregator createPercentileRanksAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new HDRPercentileRanksAggregator(name, config, context, parent, values, this.numberOfSignificantValueDigits, keyed, formatter, metadata);
        }

        @Override
        public InternalNumericMetricsAggregation.MultiValue createEmptyPercentileRanksAggregator(String name, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
            return InternalHDRPercentileRanks.empty(name, values, keyed, formatter, metadata);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.numberOfSignificantValueDigits);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.getMethod().toString());
            builder.field(PercentilesMethod.NUMBER_SIGNIFICANT_DIGITS_FIELD.getPreferredName(), this.numberOfSignificantValueDigits);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Hdr other = (Hdr)obj;
            return this.numberOfSignificantValueDigits == other.getNumberOfSignificantValueDigits();
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.numberOfSignificantValueDigits);
        }
    }

    public static final class TDigest
    extends PercentilesConfig {
        static final double DEFAULT_COMPRESSION = 100.0;
        private double compression;
        private TDigestExecutionHint executionHint;

        public TDigest() {
            this(100.0);
        }

        public TDigest(double compression) {
            this(compression, null);
        }

        public TDigest(double compression, TDigestExecutionHint executionHint) {
            super(PercentilesMethod.TDIGEST);
            this.executionHint = executionHint;
            this.setCompression(compression);
        }

        TDigest(StreamInput in) throws IOException {
            this(in.readDouble(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(TDigestExecutionHint::readFrom) : TDigestExecutionHint.HIGH_ACCURACY);
        }

        public void setCompression(double compression) {
            if (compression < 0.0) {
                throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "]");
            }
            this.compression = compression;
        }

        public double getCompression() {
            return this.compression;
        }

        public void parseExecutionHint(String executionHint) {
            this.executionHint = TDigestExecutionHint.parse(executionHint);
        }

        public TDigestExecutionHint getExecutionHint(AggregationContext context) {
            if (this.executionHint == null) {
                this.executionHint = TDigestExecutionHint.parse(context.getClusterSettings().get(TDigestExecutionHint.SETTING));
            }
            return this.executionHint;
        }

        @Override
        public Aggregator createPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new TDigestPercentilesAggregator(name, config, context, parent, values, this.compression, this.getExecutionHint(context), keyed, formatter, metadata);
        }

        @Override
        public InternalNumericMetricsAggregation.MultiValue createEmptyPercentilesAggregator(String name, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
            return InternalTDigestPercentiles.empty(name, values, keyed, formatter, metadata);
        }

        @Override
        Aggregator createPercentileRanksAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
            return new TDigestPercentileRanksAggregator(name, config, context, parent, values, this.compression, this.getExecutionHint(context), keyed, formatter, metadata);
        }

        @Override
        public InternalNumericMetricsAggregation.MultiValue createEmptyPercentileRanksAggregator(String name, double[] values, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
            TDigestExecutionHint hint = this.executionHint == null ? TDigestExecutionHint.DEFAULT : this.executionHint;
            return InternalTDigestPercentileRanks.empty(name, values, this.compression, hint, keyed, formatter, metadata);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeDouble(this.compression);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                out.writeOptionalWriteable(this.executionHint);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.getMethod().toString());
            builder.field(PercentilesMethod.COMPRESSION_FIELD.getPreferredName(), this.compression);
            if (this.executionHint != null) {
                builder.field(PercentilesMethod.EXECUTION_HINT_FIELD.getPreferredName(), (Enum)this.executionHint);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            TDigest other = (TDigest)obj;
            return this.compression == other.getCompression() && Objects.equals(this.executionHint, other.executionHint);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.compression, this.executionHint);
        }
    }
}

