/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.util.function.Function;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;

class BucketPriorityQueue<A, B extends InternalGeoGridBucket>
extends ObjectArrayPriorityQueue<A> {
    private final Function<A, B> bucketSupplier;

    BucketPriorityQueue(int size, BigArrays bigArrays, Function<A, B> bucketSupplier) {
        super(size, bigArrays);
        this.bucketSupplier = bucketSupplier;
    }

    @Override
    protected boolean lessThan(A o1, A o2) {
        InternalGeoGridBucket b1 = (InternalGeoGridBucket)this.bucketSupplier.apply(o1);
        InternalGeoGridBucket b2 = (InternalGeoGridBucket)this.bucketSupplier.apply(o2);
        int cmp = Long.compare(b2.getDocCount(), b1.getDocCount());
        if (cmp == 0 && (cmp = b2.compareTo(b1)) == 0) {
            cmp = System.identityHashCode(o2) - System.identityHashCode(o1);
        }
        return cmp > 0;
    }
}

