/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.admin.indices.resolve.ResolveClusterActionRequest;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.admin.indices.resolve.TransportResolveClusterAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestResolveClusterAction
extends BaseRestHandler {
    private static Set<String> INDEX_OPTIONS_PARAMS = Set.of("expand_wildcards", "ignore_unavailable", "allow_no_indices", "ignore_throttled");

    @Override
    public String getName() {
        return "resolve_cluster_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_resolve/cluster"), new RestHandler.Route(RestRequest.Method.GET, "/_resolve/cluster/{name}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean clusterInfoOnly;
        String[] indexExpressions;
        if (request.hasParam("name")) {
            indexExpressions = Strings.splitStringByCommaToArray(request.param("name"));
            clusterInfoOnly = false;
        } else {
            indexExpressions = new String[]{};
            clusterInfoOnly = true;
            Set<String> indexOptions = RestResolveClusterAction.requestIndexOptionsParams(request);
            if (!indexOptions.isEmpty()) {
                throw new IllegalArgumentException("No index options are allowed on _resolve/cluster when no index expression is specified, but received: " + String.valueOf(indexOptions));
            }
        }
        ResolveClusterActionRequest resolveRequest = new ResolveClusterActionRequest(indexExpressions, IndicesOptions.fromRequest(request, ResolveIndexAction.Request.DEFAULT_INDICES_OPTIONS), clusterInfoOnly, true);
        String timeout = request.param("timeout");
        if (timeout != null) {
            resolveRequest.setTimeout(TimeValue.parseTimeValue((String)timeout, (String)"timeout"));
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().indices().execute(TransportResolveClusterAction.TYPE, resolveRequest, new RestToXContentListener((RestChannel)channel));
    }

    private static Set<String> requestIndexOptionsParams(RestRequest request) {
        return Sets.intersection(request.params().keySet(), INDEX_OPTIONS_PARAMS);
    }
}

