/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.scanners;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.scanners.ExtensiblesRegistry;
import org.elasticsearch.plugins.scanners.NameToPluginInfo;
import org.elasticsearch.plugins.scanners.PluginInfo;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class NamedComponentReader {
    private static final Logger logger = LogManager.getLogger(NamedComponentReader.class);
    private static final String NAMED_COMPONENTS_FILE_NAME = "named_components.json";
    private final ExtensiblesRegistry extensiblesRegistry;

    public NamedComponentReader() {
        this(ExtensiblesRegistry.INSTANCE);
    }

    NamedComponentReader(ExtensiblesRegistry extensiblesRegistry) {
        this.extensiblesRegistry = extensiblesRegistry;
    }

    public Map<String, NameToPluginInfo> findNamedComponents(PluginBundle bundle, ClassLoader pluginClassLoader) {
        Path pluginDir = bundle.getDir();
        return this.findNamedComponents(pluginDir, pluginClassLoader);
    }

    Map<String, NameToPluginInfo> findNamedComponents(Path pluginDir, ClassLoader pluginClassLoader) {
        try {
            Path namedComponent = NamedComponentReader.findNamedComponentCacheFile(pluginDir);
            if (namedComponent != null) {
                Map<String, NameToPluginInfo> namedComponents = this.readFromFile(namedComponent, pluginClassLoader);
                logger.debug(() -> Strings.format((String)"Plugin in dir %s declared named components %s.", (Object[])new Object[]{pluginDir, namedComponents}));
                return namedComponents;
            }
            logger.debug(() -> Strings.format((String)"No named component defined in plugin dir %s", (Object[])new Object[]{pluginDir}));
        }
        catch (IOException e) {
            logger.error("unable to read named components", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private static Path findNamedComponentCacheFile(Path pluginDir) throws IOException {
        try (Stream<Path> list = Files.list(pluginDir);){
            Path path = list.filter(p -> p.getFileName().toString().equals(NAMED_COMPONENTS_FILE_NAME)).findFirst().orElse(null);
            return path;
        }
    }

    Map<String, NameToPluginInfo> readFromFile(Path namedComponent, ClassLoader pluginClassLoader) throws IOException {
        HashMap<String, NameToPluginInfo> res = new HashMap<String, NameToPluginInfo>();
        try (BufferedInputStream json = new BufferedInputStream(Files.newInputStream(namedComponent, new OpenOption[0]));
             XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)json);){
            Map map = parser.map();
            for (Map.Entry fileAsMap : map.entrySet()) {
                String extensibleInterface = (String)fileAsMap.getKey();
                this.validateExtensible(extensibleInterface);
                Map components = (Map)fileAsMap.getValue();
                for (Map.Entry nameToComponent : components.entrySet()) {
                    String name = (String)nameToComponent.getKey();
                    String value = (String)nameToComponent.getValue();
                    res.computeIfAbsent(extensibleInterface, k -> new NameToPluginInfo()).put(name, new PluginInfo(name, value, pluginClassLoader));
                }
            }
        }
        return res;
    }

    private void validateExtensible(String extensibleInterface) {
        if (!this.extensiblesRegistry.hasExtensible(extensibleInterface)) {
            throw new IllegalStateException("Unknown extensible name " + extensibleInterface);
        }
    }
}

