/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.HealthPlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RecoveryPlannerPlugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;

final class PluginIntrospector {
    private final Set<Class<?>> pluginClasses = Set.of(Plugin.class, ActionPlugin.class, AnalysisPlugin.class, CircuitBreakerPlugin.class, ClusterPlugin.class, DiscoveryPlugin.class, EnginePlugin.class, ExtensiblePlugin.class, HealthPlugin.class, IndexStorePlugin.class, IngestPlugin.class, MapperPlugin.class, NetworkPlugin.class, PersistentTaskPlugin.class, RecoveryPlannerPlugin.class, ReloadablePlugin.class, RepositoryPlugin.class, ScriptPlugin.class, SearchPlugin.class, ShutdownAwarePlugin.class, SystemIndexPlugin.class);
    private final Set<Class<?>> deprecatedPluginClasses = this.pluginClasses.stream().filter(c -> c.isAnnotationPresent(Deprecated.class)).collect(Collectors.toUnmodifiableSet());
    private final Map<Class<?>, List<MethodType>> pluginMethodsMap = this.pluginClasses.stream().collect(Collectors.toMap(Function.identity(), PluginIntrospector::findMethods));
    private final Map<Class<?>, List<MethodType>> pluginDeprecatedMethodsMap = this.pluginMethodsMap.entrySet().stream().map(e -> Map.entry((Class)e.getKey(), ((List)e.getValue()).stream().filter(MethodType::isDeprecated).toList())).filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    private PluginIntrospector() {
    }

    static PluginIntrospector getInstance() {
        return new PluginIntrospector();
    }

    List<String> interfaces(Class<?> pluginClass) {
        assert (Plugin.class.isAssignableFrom(pluginClass));
        return PluginIntrospector.interfaceClasses(pluginClass, this.pluginClasses::contains).map(Class::getSimpleName).sorted().toList();
    }

    List<String> overriddenMethods(Class<?> pluginClass) {
        return PluginIntrospector.findOverriddenMethods(pluginClass, this.pluginMethodsMap).keySet().stream().sorted().toList();
    }

    List<String> deprecatedInterfaces(Class<?> pluginClass) {
        assert (Plugin.class.isAssignableFrom(pluginClass));
        return PluginIntrospector.interfaceClasses(pluginClass, this.deprecatedPluginClasses::contains).map(Class::getSimpleName).sorted().toList();
    }

    Map<String, String> deprecatedMethods(Class<?> pluginClass) {
        return PluginIntrospector.findOverriddenMethods(pluginClass, this.pluginDeprecatedMethodsMap);
    }

    private static Map<String, String> findOverriddenMethods(Class<?> pluginClass, Map<Class<?>, List<MethodType>> methodsMap) {
        assert (Plugin.class.isAssignableFrom(pluginClass));
        List<Class<?>> clazzes = Stream.concat(Stream.of(Plugin.class), PluginIntrospector.interfaceClasses(pluginClass, methodsMap::containsKey)).toList();
        if (clazzes.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> overriddenMethods = new HashMap<String, String>();
        for (Class<?> clazz : clazzes) {
            List<MethodType> methods = methodsMap.get(clazz);
            if (methods == null) continue;
            for (MethodType mt : methods) {
                try {
                    Method m = pluginClass.getMethod(mt.name(), mt.parameterTypes());
                    if (m.getDeclaringClass() == clazz) continue;
                    assert (clazz.isAssignableFrom(m.getDeclaringClass()));
                    String existing = overriddenMethods.put(mt.name(), clazz.getSimpleName());
                    assert (existing == null);
                }
                catch (NoSuchMethodException unexpected) {
                    throw new AssertionError((Object)unexpected);
                }
            }
        }
        return Map.copyOf(overriddenMethods);
    }

    @SuppressForbidden(reason="Need declared methods")
    private static List<MethodType> findMethods(Class<?> cls) {
        assert (cls.getName().startsWith("org.elasticsearch.plugins"));
        assert (cls.isInterface() || cls == Plugin.class) : cls;
        return Arrays.stream(cls.getDeclaredMethods()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(m -> new MethodType(m.getName(), m.getParameterTypes(), m.isAnnotationPresent(Deprecated.class))).toList();
    }

    private static Stream<Class<?>> interfaceClasses(Class<?> pluginClass, Predicate<Class<?>> classPredicate) {
        assert (Plugin.class.isAssignableFrom(pluginClass));
        HashSet pluginInterfaces = new HashSet();
        do {
            Arrays.stream(pluginClass.getInterfaces()).forEach(inf -> PluginIntrospector.superInterfaces(inf, pluginInterfaces, classPredicate));
        } while ((pluginClass = pluginClass.getSuperclass()) != Object.class);
        return pluginInterfaces.stream();
    }

    private static void superInterfaces(Class<?> c, Set<Class<?>> interfaces, Predicate<Class<?>> classPredicate) {
        if (classPredicate.test(c)) {
            interfaces.add(c);
        }
        Arrays.stream(c.getInterfaces()).forEach(inf -> PluginIntrospector.superInterfaces(inf, interfaces, classPredicate));
    }

    private record MethodType(String name, Class<?>[] parameterTypes, boolean isDeprecated) {
    }
}

