/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasks;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.persistent.decider.AssignmentDecision;
import org.elasticsearch.persistent.decider.EnableAssignmentDecider;
import org.elasticsearch.threadpool.ThreadPool;

public final class PersistentTasksClusterService
implements ClusterStateListener,
Closeable {
    public static final Setting<TimeValue> CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING = Setting.timeSetting("cluster.persistent_tasks.allocation.recheck_interval", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(PersistentTasksClusterService.class);
    private final ClusterService clusterService;
    private final PersistentTasksExecutorRegistry registry;
    private final EnableAssignmentDecider enableDecider;
    private final ThreadPool threadPool;
    private final PeriodicRechecker periodicRechecker;
    private final AtomicBoolean reassigningTasks = new AtomicBoolean(false);

    public PersistentTasksClusterService(Settings settings, PersistentTasksExecutorRegistry registry, ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.registry = registry;
        this.enableDecider = new EnableAssignmentDecider(settings, clusterService.getClusterSettings());
        this.threadPool = threadPool;
        this.periodicRechecker = new PeriodicRechecker(CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING.get(settings));
        if (DiscoveryNode.isMasterNode(settings)) {
            clusterService.addListener(this);
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING, this::setRecheckInterval);
    }

    public void setRecheckInterval(TimeValue recheckInterval) {
        this.periodicRechecker.setInterval(recheckInterval);
    }

    PeriodicRechecker getPeriodicRechecker() {
        return this.periodicRechecker;
    }

    @Override
    public void close() {
        this.periodicRechecker.close();
    }

    public <Params extends PersistentTaskParams> void createProjectPersistentTask(ProjectId projectId, String taskId, String taskName, Params taskParams, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.createPersistentTask(Objects.requireNonNull(projectId), taskId, taskName, taskParams, listener);
    }

    public <Params extends PersistentTaskParams> void createClusterPersistentTask(String taskId, String taskName, Params taskParams, ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.createPersistentTask(null, taskId, taskName, taskParams, listener);
    }

    private <Params extends PersistentTaskParams> void createPersistentTask(final @Nullable ProjectId projectId, final String taskId, final String taskName, final Params taskParams, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.submitUnbatchedTask("create persistent task " + taskName + " [" + taskId + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                Object builder = PersistentTasksClusterService.builder(currentState, projectId).setLastAllocationId(currentState);
                if (((PersistentTasks.Builder)builder).hasTask(taskId)) {
                    throw new ResourceAlreadyExistsException("task with id {" + taskId + "} already exist", new Object[0]);
                }
                PersistentTasksExecutor<PersistentTaskParams> taskExecutor = PersistentTasksClusterService.this.registry.getPersistentTaskExecutorSafe(taskName);
                assert (projectId == null && taskExecutor.scope() == PersistentTasksExecutor.Scope.CLUSTER || projectId != null && taskExecutor.scope() == PersistentTasksExecutor.Scope.PROJECT) : "inconsistent project-id [" + String.valueOf(projectId) + "] and task scope [" + String.valueOf((Object)taskExecutor.scope()) + "]";
                taskExecutor.validate(taskParams, currentState, projectId);
                PersistentTasksCustomMetadata.Assignment assignment = PersistentTasksClusterService.this.createAssignment(taskName, taskParams, currentState, projectId);
                logger.debug("creating {} persistent task [{}] with assignment [{}]", (Object)PersistentTasks.taskTypeString(projectId), (Object)taskName, (Object)assignment);
                return ((PersistentTasks.Builder)((PersistentTasks.Builder)builder).addTask(taskId, taskName, (PersistentTaskParams)taskParams, assignment)).buildAndUpdate(currentState, projectId);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                PersistentTasks tasks = PersistentTasks.getTasks(newState, projectId);
                if (tasks != null) {
                    PersistentTasksCustomMetadata.PersistentTask<?> task = tasks.getTask(taskId);
                    listener.onResponse(task);
                    if (task != null && !task.isAssigned() && !PersistentTasksClusterService.this.periodicRechecker.isScheduled()) {
                        PersistentTasksClusterService.this.periodicRechecker.rescheduleIfNecessary();
                    }
                } else {
                    listener.onResponse(null);
                }
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    void completePersistentTask(final @Nullable ProjectId projectIdHint, final String id, final long allocationId, Exception failure, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        String source;
        if (failure != null) {
            logger.warn(PersistentTasks.taskTypeString(projectIdHint) + " persistent task " + id + " failed", (Throwable)failure);
            source = "finish " + PersistentTasks.taskTypeString(projectIdHint) + " persistent task [" + id + "] (failed)";
        } else {
            source = "finish " + PersistentTasks.taskTypeString(projectIdHint) + " persistent task [" + id + "] (success)";
        }
        this.submitUnbatchedTask(source, new ClusterStateUpdateTask(this){
            private volatile ProjectId projectId;

            @Override
            public ClusterState execute(ClusterState currentState) {
                this.projectId = PersistentTasksClusterService.maybeNullProjectIdForClusterTask(currentState, projectIdHint, id);
                PersistentTasks.Builder<?> tasksInProgress = PersistentTasksClusterService.builder(currentState, this.projectId);
                if (tasksInProgress.hasTask(id, allocationId)) {
                    tasksInProgress.removeTask(id);
                    return tasksInProgress.buildAndUpdate(currentState, this.projectId);
                }
                if (tasksInProgress.hasTask(id)) {
                    logger.warn("The {} task [{}] with id [{}] was found but it has a different allocation id [{}], status is not updated", (Object)PersistentTasks.taskTypeString(this.projectId), (Object)tasksInProgress.getCurrentTasks().get(id).getTaskName(), (Object)id, (Object)allocationId);
                } else {
                    logger.warn("The {} task [{}] wasn't found, status is not updated", (Object)PersistentTasks.taskTypeString(this.projectId), (Object)id);
                }
                throw new ResourceNotFoundException("the " + PersistentTasks.taskTypeString(this.projectId) + " task with id [" + id + "] and allocation id [" + allocationId + "] not found", new Object[0]);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                PersistentTasks tasks = PersistentTasks.getTasks(oldState, this.projectId);
                listener.onResponse(tasks == null ? null : tasks.getTask(id));
            }
        });
    }

    void removePersistentTask(final @Nullable ProjectId projectIdHint, final String id, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.submitUnbatchedTask("remove " + PersistentTasks.taskTypeString(projectIdHint) + " persistent task [" + id + "]", new ClusterStateUpdateTask(this){
            private volatile ProjectId projectId;

            @Override
            public ClusterState execute(ClusterState currentState) {
                this.projectId = PersistentTasksClusterService.maybeNullProjectIdForClusterTask(currentState, projectIdHint, id);
                PersistentTasks.Builder<?> tasksInProgress = PersistentTasksClusterService.builder(currentState, this.projectId);
                if (tasksInProgress.hasTask(id)) {
                    return ((PersistentTasks.Builder)tasksInProgress.removeTask(id)).buildAndUpdate(currentState, this.projectId);
                }
                throw new ResourceNotFoundException("the " + PersistentTasks.taskTypeString(this.projectId) + " task with id {} doesn't exist", id);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse(Optional.ofNullable(PersistentTasks.getTasks(oldState, this.projectId)).map(tasks -> tasks.getTask(id)).orElse(null));
            }
        });
    }

    void updatePersistentTaskState(final @Nullable ProjectId projectIdHint, final String taskId, final long taskAllocationId, final PersistentTaskState taskState, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.submitUnbatchedTask("update " + PersistentTasks.taskTypeString(projectIdHint) + " task state [" + taskId + "]", new ClusterStateUpdateTask(this){
            private volatile ProjectId projectId;

            @Override
            public ClusterState execute(ClusterState currentState) {
                this.projectId = PersistentTasksClusterService.maybeNullProjectIdForClusterTask(currentState, projectIdHint, taskId);
                PersistentTasks.Builder<?> tasksInProgress = PersistentTasksClusterService.builder(currentState, this.projectId);
                if (tasksInProgress.hasTask(taskId, taskAllocationId)) {
                    return ((PersistentTasks.Builder)tasksInProgress.updateTaskState(taskId, taskState)).buildAndUpdate(currentState, this.projectId);
                }
                if (tasksInProgress.hasTask(taskId)) {
                    logger.warn("trying to update state on {} task {} with unexpected allocation id {}", (Object)PersistentTasks.taskTypeString(this.projectId), (Object)taskId, (Object)taskAllocationId);
                } else {
                    logger.warn("trying to update state on non-existing {} task {}", (Object)PersistentTasks.taskTypeString(this.projectId), (Object)taskId);
                }
                throw new ResourceNotFoundException("the {} task with id {} and allocation id {} doesn't exist", PersistentTasks.taskTypeString(this.projectId), taskId, taskAllocationId);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse(Optional.ofNullable(PersistentTasks.getTasks(newState, this.projectId)).map(tasks -> tasks.getTask(taskId)).orElse(null));
            }
        });
    }

    public void unassignPersistentTask(final @Nullable ProjectId projectIdHint, final String taskId, final long taskAllocationId, final String reason, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.submitUnbatchedTask("unassign " + PersistentTasks.taskTypeString(projectIdHint) + " persistent task [" + taskId + "] from any node", new ClusterStateUpdateTask(this){
            private volatile ProjectId projectId;

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                this.projectId = PersistentTasksClusterService.maybeNullProjectIdForClusterTask(currentState, projectIdHint, taskId);
                PersistentTasks.Builder<?> tasksInProgress = PersistentTasksClusterService.builder(currentState, this.projectId);
                if (tasksInProgress.hasTask(taskId, taskAllocationId)) {
                    logger.trace("Unassigning {} task {} with allocation id {}", (Object)PersistentTasks.taskTypeString(this.projectId), (Object)taskId, (Object)taskAllocationId);
                    return ((PersistentTasks.Builder)((PersistentTasks.Builder)tasksInProgress.setLastAllocationId(currentState)).reassignTask(taskId, PersistentTasksClusterService.unassignedAssignment(reason))).buildAndUpdate(currentState, this.projectId);
                }
                throw new ResourceNotFoundException("the {} task with id {} and allocation id {} doesn't exist", PersistentTasks.taskTypeString(this.projectId), taskId, taskAllocationId);
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse(Optional.ofNullable(PersistentTasks.getTasks(newState, this.projectId)).map(tasks -> tasks.getTask(taskId)).orElse(null));
            }
        });
    }

    private <Params extends PersistentTaskParams> PersistentTasksCustomMetadata.Assignment createAssignment(String taskName, Params taskParams, ClusterState currentState, @Nullable ProjectId projectId) {
        PersistentTasksExecutor<Params> persistentTasksExecutor = this.registry.getPersistentTaskExecutorSafe(taskName);
        AssignmentDecision decision = this.enableDecider.canAssign();
        if (decision.getType() == AssignmentDecision.Type.NO) {
            return PersistentTasksClusterService.unassignedAssignment("persistent task [" + taskName + "] cannot be assigned [" + decision.getReason() + "]");
        }
        List candidateNodes = currentState.nodes().stream().filter(dn -> !currentState.metadata().nodeShutdowns().contains(dn.getId())).collect(Collectors.toCollection(ArrayList::new));
        Randomness.shuffle(candidateNodes);
        PersistentTasksCustomMetadata.Assignment assignment = persistentTasksExecutor.getAssignment(taskParams, candidateNodes, currentState, projectId);
        assert (assignment != null) : "getAssignment() should always return an Assignment object, containing a node or a reason why not";
        assert (assignment.getExecutorNode() == null || !currentState.metadata().nodeShutdowns().contains(assignment.getExecutorNode())) : "expected task [" + taskName + "] to be assigned to a node that is not marked as shutting down, but " + assignment.getExecutorNode() + " is currently marked as shutting down";
        return assignment;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            if (this.shouldReassignPersistentTasks(event)) {
                this.periodicRechecker.cancel();
                logger.trace("checking task reassignment for cluster state {}", (Object)event.state().getVersion());
                this.reassignPersistentTasks();
            }
        } else {
            this.periodicRechecker.cancel();
        }
    }

    void reassignPersistentTasks() {
        if (!this.reassigningTasks.compareAndSet(false, true)) {
            return;
        }
        this.submitUnbatchedTask("reassign persistent tasks", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return PersistentTasksClusterService.this.reassignTasks(currentState);
            }

            @Override
            public void onFailure(Exception e) {
                PersistentTasksClusterService.this.reassigningTasks.set(false);
                logger.warn("failed to reassign persistent tasks", (Throwable)e);
                if (!(e instanceof NotMasterException)) {
                    try {
                        PersistentTasksClusterService.this.periodicRechecker.rescheduleIfNecessary();
                    }
                    catch (Exception e2) {
                        EsRejectedExecutionException esre;
                        assert (e2 instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e2).isExecutorShutdown()) : e2;
                        logger.warn("failed to reschedule persistent tasks rechecker", (Throwable)e2);
                    }
                }
            }

            @Override
            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                PersistentTasksClusterService.this.reassigningTasks.set(false);
                if (PersistentTasksClusterService.isAnyTaskUnassigned(PersistentTasks.getAllTasks(newState))) {
                    PersistentTasksClusterService.this.periodicRechecker.rescheduleIfNecessary();
                }
            }
        });
    }

    boolean shouldReassignPersistentTasks(ClusterChangedEvent event) {
        boolean masterChanged;
        Iterator projectIdToTasksIterator = PersistentTasks.getAllTasks(event.state()).iterator();
        if (!projectIdToTasksIterator.hasNext()) {
            return false;
        }
        boolean bl = masterChanged = !event.previousState().nodes().isLocalNodeElectedMaster();
        if (PersistentTasksClusterService.persistentTasksChanged(event) || event.nodesChanged() || event.routingTableChanged() || event.metadataChanged() || masterChanged) {
            while (projectIdToTasksIterator.hasNext()) {
                Tuple projectIdToTasks = (Tuple)projectIdToTasksIterator.next();
                for (PersistentTasksCustomMetadata.PersistentTask<?> task : ((PersistentTasks)projectIdToTasks.v2()).tasks()) {
                    PersistentTasksCustomMetadata.Assignment assignment;
                    if (!PersistentTasksClusterService.needsReassignment(task.getAssignment(), event.state().nodes()) || Objects.equals(assignment = this.createAssignment(task.getTaskName(), (PersistentTaskParams)task.getParams(), event.state(), (ProjectId)projectIdToTasks.v1()), task.getAssignment())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAnyTaskUnassigned(Stream<Tuple<ProjectId, PersistentTasks>> projectIdTasksTuples) {
        return projectIdTasksTuples.flatMap(tasks -> ((PersistentTasks)tasks.v2()).tasks().stream()).anyMatch(task -> !task.getAssignment().isAssigned());
    }

    ClusterState reassignTasks(ClusterState currentState) {
        ClusterState clusterState = currentState;
        clusterState = this.reassignClusterOrSingleProjectTasks(null, clusterState);
        for (ProjectId projectId : currentState.metadata().projects().keySet()) {
            clusterState = this.reassignClusterOrSingleProjectTasks(projectId, clusterState);
        }
        return clusterState;
    }

    private ClusterState reassignClusterOrSingleProjectTasks(@Nullable ProjectId projectId, ClusterState currentState) {
        ClusterState clusterState = currentState;
        PersistentTasks tasks = PersistentTasks.getTasks(currentState, projectId);
        if (tasks != null) {
            logger.trace("reassigning {} {} persistent tasks", (Object)tasks.tasks().size(), (Object)PersistentTasks.taskTypeString(projectId));
            DiscoveryNodes nodes = currentState.nodes();
            for (PersistentTasksCustomMetadata.PersistentTask<?> task : tasks.tasks()) {
                if (PersistentTasksClusterService.needsReassignment(task.getAssignment(), nodes)) {
                    PersistentTasksCustomMetadata.Assignment assignment = this.createAssignment(task.getTaskName(), (PersistentTaskParams)task.getParams(), clusterState, projectId);
                    if (!Objects.equals(assignment, task.getAssignment())) {
                        logger.trace("reassigning {} task {} from node {} to node {}", (Object)PersistentTasks.taskTypeString(projectId), (Object)task.getId(), (Object)task.getAssignment().getExecutorNode(), (Object)assignment.getExecutorNode());
                        clusterState = ((PersistentTasks.Builder)((PersistentTasks.Builder)PersistentTasksClusterService.builder(clusterState, projectId).setLastAllocationId(clusterState)).reassignTask(task.getId(), assignment)).buildAndUpdate(clusterState, projectId);
                        continue;
                    }
                    logger.trace("ignoring {} task {} because assignment is the same {}", (Object)PersistentTasks.taskTypeString(projectId), (Object)task.getId(), (Object)assignment);
                    continue;
                }
                logger.trace("ignoring {} task {} because it is still running", (Object)PersistentTasks.taskTypeString(projectId), (Object)task.getId());
            }
        }
        return clusterState;
    }

    static boolean persistentTasksChanged(ClusterChangedEvent event) {
        if (!Objects.equals(ClusterPersistentTasksCustomMetadata.get(event.state().metadata()), ClusterPersistentTasksCustomMetadata.get(event.previousState().metadata()))) {
            return true;
        }
        Set<ProjectId> previousProjectIds = event.previousState().metadata().projects().keySet();
        Set<ProjectId> projectIds = event.state().metadata().projects().keySet();
        for (ProjectId projectId : projectIds) {
            if (!(previousProjectIds.contains(projectId) ? !Objects.equals(PersistentTasksCustomMetadata.get(event.state().metadata().getProject(projectId)), PersistentTasksCustomMetadata.get(event.previousState().metadata().getProject(projectId))) : PersistentTasksCustomMetadata.get(event.state().metadata().getProject(projectId)) != null)) continue;
            return true;
        }
        return false;
    }

    public static boolean needsReassignment(PersistentTasksCustomMetadata.Assignment assignment, DiscoveryNodes nodes) {
        return !assignment.isAssigned() || !nodes.nodeExists(assignment.getExecutorNode());
    }

    private static PersistentTasks.Builder<?> builder(ClusterState currentState, @Nullable ProjectId projectId) {
        if (projectId == null) {
            return ClusterPersistentTasksCustomMetadata.builder(ClusterPersistentTasksCustomMetadata.get(currentState.metadata()));
        }
        return PersistentTasksCustomMetadata.builder(PersistentTasksCustomMetadata.get(currentState.getMetadata().getProject(projectId)));
    }

    @Nullable
    static ProjectId resolveProjectIdHint(ProjectResolver projectResolver) {
        try {
            return projectResolver.getProjectId();
        }
        catch (Exception e) {
            logger.debug("skipping error on resolving project-id", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ProjectId maybeNullProjectIdForClusterTask(ClusterState clusterState, @Nullable ProjectId projectIdHint, String taskId) {
        if (projectIdHint == null) {
            return null;
        }
        ClusterPersistentTasksCustomMetadata clusterTasks = ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
        if (clusterTasks != null && clusterTasks.getTask(taskId) != null) {
            assert (PersistentTasksClusterService.assertProjectIdHintIsTheDefaultProjectId(projectIdHint));
            logger.debug("task [{}] is cluster-scoped but project ID [{}] is non-null, ignoring the project ID", (Object)taskId, (Object)projectIdHint);
            return null;
        }
        return projectIdHint;
    }

    private static boolean assertProjectIdHintIsTheDefaultProjectId(ProjectId projectIdHint) {
        assert (Metadata.DEFAULT_PROJECT_ID.equals(projectIdHint)) : "expected default project ID when ignoring persistent task project ID hint but got " + String.valueOf(projectIdHint);
        return true;
    }

    static boolean assertAllocationIdsConsistency(ClusterState clusterState) {
        ClusterPersistentTasksCustomMetadata clusterPersistentTasksCustomMetadata = ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
        assert (PersistentTasksCustomMetadata.assertAllocationIdsConsistencyForOnePersistentTasks(clusterPersistentTasksCustomMetadata));
        ArrayList<AbstractNamedDiffable> allPersistentTasks = new ArrayList<AbstractNamedDiffable>();
        allPersistentTasks.add(clusterPersistentTasksCustomMetadata);
        List<ProjectMetadata> projects = List.copyOf(clusterState.metadata().projects().values());
        for (ProjectMetadata projectMetadata : projects) {
            PersistentTasksCustomMetadata projectPersistentTasksCustomMetadata = PersistentTasksCustomMetadata.get(projectMetadata);
            assert (PersistentTasksCustomMetadata.assertAllocationIdsConsistencyForOnePersistentTasks(projectPersistentTasksCustomMetadata));
            allPersistentTasks.add(projectPersistentTasksCustomMetadata);
        }
        for (int i = 0; i < allPersistentTasks.size() - 1; ++i) {
            PersistentTasks persistentTasks1 = (PersistentTasks)allPersistentTasks.get(i);
            if (persistentTasks1 == null) continue;
            for (int j = i + 1; j < allPersistentTasks.size(); ++j) {
                PersistentTasks persistentTasks2 = (PersistentTasks)allPersistentTasks.get(j);
                if (persistentTasks2 != null) assert (Sets.intersection(Set.copyOf(PersistentTasksCustomMetadata.getNonZeroAllocationIds(persistentTasks1)), Set.copyOf(PersistentTasksCustomMetadata.getNonZeroAllocationIds(persistentTasks2))).isEmpty()) : "duplicated allocationId found between " + (String)(i == 0 ? "cluster" : "project [" + String.valueOf(projects.get(i - 1).id()) + "]") + " scoped persistent tasks [" + String.valueOf(persistentTasks1) + "] and project [" + String.valueOf(projects.get(j - 1).id()) + "] scoped persistent tasks [" + String.valueOf(persistentTasks2) + "]";
            }
        }
        return true;
    }

    static boolean assertUniqueTaskIdForClusterScopeTasks(ClusterState clusterState) {
        ClusterPersistentTasksCustomMetadata clusterTasks = ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
        if (clusterTasks == null) {
            return true;
        }
        Set<String> clusterTaskIds = clusterTasks.taskMap().keySet();
        for (ProjectId projectId : clusterState.metadata().projects().keySet()) {
            PersistentTasks projectTasks = PersistentTasks.getTasks(clusterState, projectId);
            if (projectTasks == null) continue;
            Set<String> projectTaskIds = projectTasks.taskMap().keySet();
            Set<String> intersection = Sets.intersection(clusterTaskIds, projectTaskIds);
            assert (intersection.isEmpty()) : "duplicated task ID found between cluster and project persistent tasks " + String.valueOf(intersection);
        }
        return true;
    }

    private static PersistentTasksCustomMetadata.Assignment unassignedAssignment(String reason) {
        return new PersistentTasksCustomMetadata.Assignment(null, reason);
    }

    class PeriodicRechecker
    extends AbstractAsyncTask {
        PeriodicRechecker(TimeValue recheckInterval) {
            super(logger, PersistentTasksClusterService.this.threadPool, EsExecutors.DIRECT_EXECUTOR_SERVICE, recheckInterval, false);
        }

        @Override
        protected boolean mustReschedule() {
            return true;
        }

        @Override
        public void runInternal() {
            if (PersistentTasksClusterService.this.clusterService.localNode().isMasterNode()) {
                ClusterState state = PersistentTasksClusterService.this.clusterService.state();
                logger.trace("periodic persistent task assignment check running for cluster state {}", (Object)state.getVersion());
                if (PersistentTasksClusterService.isAnyTaskUnassigned(PersistentTasks.getAllTasks(state))) {
                    PersistentTasksClusterService.this.reassignPersistentTasks();
                }
            }
        }

        public String toString() {
            return "persistent_task_recheck";
        }
    }
}

