/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class OsStats
implements Writeable,
ToXContentFragment {
    private final long timestamp;
    private final Cpu cpu;
    private final Mem mem;
    private final Swap swap;
    private final Cgroup cgroup;

    public OsStats(long timestamp, Cpu cpu, Mem mem, Swap swap, Cgroup cgroup) {
        this.timestamp = timestamp;
        this.cpu = Objects.requireNonNull(cpu);
        this.mem = Objects.requireNonNull(mem);
        this.swap = Objects.requireNonNull(swap);
        this.cgroup = cgroup;
    }

    public OsStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.cpu = new Cpu(in);
        this.mem = new Mem(in);
        this.swap = new Swap(in);
        this.cgroup = in.readOptionalWriteable(Cgroup::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        this.cpu.writeTo(out);
        this.mem.writeTo(out);
        this.swap.writeTo(out);
        out.writeOptionalWriteable(this.cgroup);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Swap getSwap() {
        return this.swap;
    }

    public Cgroup getCgroup() {
        return this.cgroup;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("os");
        builder.field("timestamp", this.getTimestamp());
        this.cpu.toXContent(builder, params);
        this.mem.toXContent(builder, params);
        this.swap.toXContent(builder, params);
        if (this.cgroup != null) {
            this.cgroup.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static short calculatePercentage(long used, long max) {
        return max <= 0L ? (short)0 : (short)Math.round(100.0 * (double)used / (double)max);
    }

    public static class Cpu
    implements Writeable,
    ToXContentFragment {
        private final short percent;
        private final double[] loadAverage;

        public Cpu(short systemCpuPercent, double[] systemLoadAverage) {
            this.percent = systemCpuPercent;
            this.loadAverage = systemLoadAverage;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.loadAverage = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            if (this.loadAverage == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeDoubleArray(this.loadAverage);
            }
        }

        public short getPercent() {
            return this.percent;
        }

        public double[] getLoadAverage() {
            return this.loadAverage;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cpu");
            builder.field("percent", this.getPercent());
            if (this.getLoadAverage() != null && Arrays.stream(this.getLoadAverage()).anyMatch(load -> load != -1.0)) {
                builder.startObject("load_average");
                if (this.getLoadAverage()[0] != -1.0) {
                    builder.field("1m", this.getLoadAverage()[0]);
                }
                if (this.getLoadAverage()[1] != -1.0) {
                    builder.field("5m", this.getLoadAverage()[1]);
                }
                if (this.getLoadAverage()[2] != -1.0) {
                    builder.field("15m", this.getLoadAverage()[2]);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Mem
    implements Writeable,
    ToXContentFragment {
        private static final Logger logger = LogManager.getLogger(Mem.class);
        private final long total;
        private final long adjustedTotal;
        private final long free;

        public Mem(long total, long adjustedTotal, long free) {
            assert (total >= 0L) : "expected total memory to be positive, got: " + total;
            assert (adjustedTotal >= 0L) : "expected adjusted total memory to be positive, got: " + adjustedTotal;
            assert (free >= 0L) : "expected free memory to be positive, got: " + free;
            if (total < 0L) {
                logger.error("negative total memory [{}] found in memory stats", (Object)total);
                total = 0L;
            }
            if (adjustedTotal < 0L) {
                logger.error("negative adjusted total memory [{}] found in memory stats", (Object)total);
                adjustedTotal = 0L;
            }
            if (free < 0L) {
                logger.error("negative free memory [{}] found in memory stats", (Object)total);
                free = 0L;
            }
            this.total = total;
            this.adjustedTotal = adjustedTotal;
            this.free = free;
        }

        public Mem(StreamInput in) throws IOException {
            long total = in.readLong();
            assert (total >= 0L) : "expected total memory to be positive, got: " + total;
            if (total < 0L) {
                logger.error("negative total memory [{}] deserialized in memory stats", (Object)total);
                total = 0L;
            }
            this.total = total;
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
                long adjustedTotal = in.readLong();
                assert (adjustedTotal >= 0L) : "expected adjusted total memory to be positive, got: " + adjustedTotal;
                if (adjustedTotal < 0L) {
                    logger.error("negative adjusted total memory [{}] deserialized in memory stats", (Object)adjustedTotal);
                    adjustedTotal = 0L;
                }
                this.adjustedTotal = adjustedTotal;
            } else {
                this.adjustedTotal = total;
            }
            long free = in.readLong();
            assert (free >= 0L) : "expected free memory to be positive, got: " + free;
            if (free < 0L) {
                logger.error("negative free memory [{}] deserialized in memory stats", (Object)free);
                free = 0L;
            }
            this.free = free;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
                out.writeLong(this.adjustedTotal);
            }
            out.writeLong(this.free);
        }

        public ByteSizeValue getTotal() {
            return ByteSizeValue.ofBytes(this.total);
        }

        public ByteSizeValue getAdjustedTotal() {
            return ByteSizeValue.ofBytes(this.adjustedTotal);
        }

        public ByteSizeValue getUsed() {
            if (this.total == 0L) {
                if (this.free > 0L) {
                    logger.debug("cannot compute used memory when total memory is 0 and free memory is " + this.free);
                }
                return ByteSizeValue.ZERO;
            }
            return ByteSizeValue.ofBytes(this.total - this.free);
        }

        public short getUsedPercent() {
            return OsStats.calculatePercentage(this.getUsed().getBytes(), this.total);
        }

        public ByteSizeValue getFree() {
            return ByteSizeValue.ofBytes(this.free);
        }

        public short getFreePercent() {
            return OsStats.calculatePercentage(this.free, this.total);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("mem");
            builder.humanReadableField("total_in_bytes", "total", (Object)this.getTotal());
            builder.humanReadableField("adjusted_total_in_bytes", "adjusted_total", (Object)this.getAdjustedTotal());
            builder.humanReadableField("free_in_bytes", "free", (Object)this.getFree());
            builder.humanReadableField("used_in_bytes", "used", (Object)this.getUsed());
            builder.field("free_percent", this.getFreePercent());
            builder.field("used_percent", this.getUsedPercent());
            builder.endObject();
            return builder;
        }
    }

    public static class Swap
    implements Writeable,
    ToXContentFragment {
        private static final Logger logger = LogManager.getLogger(Swap.class);
        private final long total;
        private final long free;

        public Swap(long total, long free) {
            assert (total >= 0L) : "expected total swap to be positive, got: " + total;
            assert (free >= 0L) : "expected free swap to be positive, got: " + total;
            this.total = total;
            this.free = free;
        }

        public Swap(StreamInput in) throws IOException {
            this.total = in.readLong();
            assert (this.total >= 0L) : "expected total swap to be positive, got: " + this.total;
            this.free = in.readLong();
            assert (this.free >= 0L) : "expected free swap to be positive, got: " + this.total;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
            out.writeLong(this.free);
        }

        public ByteSizeValue getFree() {
            return ByteSizeValue.ofBytes(this.free);
        }

        public ByteSizeValue getUsed() {
            if (this.total == 0L) {
                if (this.free > 0L) {
                    logger.debug("cannot compute used swap when total swap is 0 and free swap is " + this.free);
                }
                return ByteSizeValue.ZERO;
            }
            return ByteSizeValue.ofBytes(this.total - this.free);
        }

        public ByteSizeValue getTotal() {
            return ByteSizeValue.ofBytes(this.total);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("swap");
            builder.humanReadableField("total_in_bytes", "total", (Object)this.getTotal());
            builder.humanReadableField("free_in_bytes", "free", (Object)this.getFree());
            builder.humanReadableField("used_in_bytes", "used", (Object)this.getUsed());
            builder.endObject();
            return builder;
        }
    }

    public static class Cgroup
    implements Writeable,
    ToXContentFragment {
        private final String cpuAcctControlGroup;
        private final BigInteger cpuAcctUsageNanos;
        private final String cpuControlGroup;
        private final long cpuCfsPeriodMicros;
        private final long cpuCfsQuotaMicros;
        private final CpuStat cpuStat;
        private final String memoryControlGroup;
        private final String memoryLimitInBytes;
        private final String memoryUsageInBytes;

        public String getCpuAcctControlGroup() {
            return this.cpuAcctControlGroup;
        }

        public BigInteger getCpuAcctUsageNanos() {
            return this.cpuAcctUsageNanos;
        }

        public String getCpuControlGroup() {
            return this.cpuControlGroup;
        }

        public long getCpuCfsPeriodMicros() {
            return this.cpuCfsPeriodMicros;
        }

        public long getCpuCfsQuotaMicros() {
            return this.cpuCfsQuotaMicros;
        }

        public CpuStat getCpuStat() {
            return this.cpuStat;
        }

        public String getMemoryControlGroup() {
            return this.memoryControlGroup;
        }

        public String getMemoryLimitInBytes() {
            return this.memoryLimitInBytes;
        }

        public String getMemoryUsageInBytes() {
            return this.memoryUsageInBytes;
        }

        public Cgroup(String cpuAcctControlGroup, BigInteger cpuAcctUsageNanos, String cpuControlGroup, long cpuCfsPeriodMicros, long cpuCfsQuotaMicros, CpuStat cpuStat, String memoryControlGroup, String memoryLimitInBytes, String memoryUsageInBytes) {
            this.cpuAcctControlGroup = Objects.requireNonNull(cpuAcctControlGroup);
            this.cpuAcctUsageNanos = cpuAcctUsageNanos;
            this.cpuControlGroup = Objects.requireNonNull(cpuControlGroup);
            this.cpuCfsPeriodMicros = cpuCfsPeriodMicros;
            this.cpuCfsQuotaMicros = cpuCfsQuotaMicros;
            this.cpuStat = Objects.requireNonNull(cpuStat);
            this.memoryControlGroup = memoryControlGroup;
            this.memoryLimitInBytes = memoryLimitInBytes;
            this.memoryUsageInBytes = memoryUsageInBytes;
        }

        Cgroup(StreamInput in) throws IOException {
            this.cpuAcctControlGroup = in.readString();
            this.cpuAcctUsageNanos = in.getTransportVersion().onOrAfter(TransportVersions.V_8_17_0) ? in.readBigInteger() : BigInteger.valueOf(in.readLong());
            this.cpuControlGroup = in.readString();
            this.cpuCfsPeriodMicros = in.readLong();
            this.cpuCfsQuotaMicros = in.readLong();
            this.cpuStat = new CpuStat(in);
            this.memoryControlGroup = in.readOptionalString();
            this.memoryLimitInBytes = in.readOptionalString();
            this.memoryUsageInBytes = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.cpuAcctControlGroup);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_17_0)) {
                out.writeBigInteger(this.cpuAcctUsageNanos);
            } else {
                out.writeLong(this.cpuAcctUsageNanos.longValue());
            }
            out.writeString(this.cpuControlGroup);
            out.writeLong(this.cpuCfsPeriodMicros);
            out.writeLong(this.cpuCfsQuotaMicros);
            this.cpuStat.writeTo(out);
            out.writeOptionalString(this.memoryControlGroup);
            out.writeOptionalString(this.memoryLimitInBytes);
            out.writeOptionalString(this.memoryUsageInBytes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("cgroup");
            builder.startObject("cpuacct");
            builder.field("control_group", this.cpuAcctControlGroup);
            builder.field("usage_nanos", this.cpuAcctUsageNanos);
            builder.endObject();
            builder.startObject("cpu");
            builder.field("control_group", this.cpuControlGroup);
            builder.field("cfs_period_micros", this.cpuCfsPeriodMicros);
            builder.field("cfs_quota_micros", this.cpuCfsQuotaMicros);
            this.cpuStat.toXContent(builder, params);
            builder.endObject();
            if (this.memoryControlGroup != null) {
                builder.startObject("memory");
                builder.field("control_group", this.memoryControlGroup);
                if (this.memoryLimitInBytes != null) {
                    builder.field("limit_in_bytes", this.memoryLimitInBytes);
                }
                if (this.memoryUsageInBytes != null) {
                    builder.field("usage_in_bytes", this.memoryUsageInBytes);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public static class CpuStat
        implements Writeable,
        ToXContentFragment {
            private final BigInteger numberOfElapsedPeriods;
            private final BigInteger numberOfTimesThrottled;
            private final BigInteger timeThrottledNanos;

            public BigInteger getNumberOfElapsedPeriods() {
                return this.numberOfElapsedPeriods;
            }

            public BigInteger getNumberOfTimesThrottled() {
                return this.numberOfTimesThrottled;
            }

            public BigInteger getTimeThrottledNanos() {
                return this.timeThrottledNanos;
            }

            public CpuStat(BigInteger numberOfElapsedPeriods, BigInteger numberOfTimesThrottled, BigInteger timeThrottledNanos) {
                this.numberOfElapsedPeriods = numberOfElapsedPeriods;
                this.numberOfTimesThrottled = numberOfTimesThrottled;
                this.timeThrottledNanos = timeThrottledNanos;
            }

            CpuStat(StreamInput in) throws IOException {
                if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_17_0)) {
                    this.numberOfElapsedPeriods = in.readBigInteger();
                    this.numberOfTimesThrottled = in.readBigInteger();
                    this.timeThrottledNanos = in.readBigInteger();
                } else {
                    this.numberOfElapsedPeriods = BigInteger.valueOf(in.readLong());
                    this.numberOfTimesThrottled = BigInteger.valueOf(in.readLong());
                    this.timeThrottledNanos = BigInteger.valueOf(in.readLong());
                }
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_17_0)) {
                    out.writeBigInteger(this.numberOfElapsedPeriods);
                    out.writeBigInteger(this.numberOfTimesThrottled);
                    out.writeBigInteger(this.timeThrottledNanos);
                } else {
                    out.writeLong(this.numberOfElapsedPeriods.longValue());
                    out.writeLong(this.numberOfTimesThrottled.longValue());
                    out.writeLong(this.timeThrottledNanos.longValue());
                }
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("stat");
                builder.field("number_of_elapsed_periods", this.numberOfElapsedPeriods);
                builder.field("number_of_times_throttled", this.numberOfTimesThrottled);
                builder.field("time_throttled_nanos", this.timeThrottledNanos);
                builder.endObject();
                return builder;
            }
        }
    }

    static final class Fields {
        static final String OS = "os";
        static final String TIMESTAMP = "timestamp";
        static final String CPU = "cpu";
        static final String PERCENT = "percent";
        static final String LOAD_AVERAGE = "load_average";
        static final String LOAD_AVERAGE_1M = "1m";
        static final String LOAD_AVERAGE_5M = "5m";
        static final String LOAD_AVERAGE_15M = "15m";
        static final String MEM = "mem";
        static final String SWAP = "swap";
        static final String FREE = "free";
        static final String FREE_IN_BYTES = "free_in_bytes";
        static final String USED = "used";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String TOTAL = "total";
        static final String TOTAL_IN_BYTES = "total_in_bytes";
        static final String ADJUSTED_TOTAL = "adjusted_total";
        static final String ADJUSTED_TOTAL_IN_BYTES = "adjusted_total_in_bytes";
        static final String FREE_PERCENT = "free_percent";
        static final String USED_PERCENT = "used_percent";

        Fields() {
        }
    }
}

