/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor;

import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Probes {
    private static final Logger logger = LogManager.getLogger(Probes.class);

    public static short getLoadAndScaleToPercent(Method method, OperatingSystemMXBean osMxBean) {
        logger.debug("Starting probe of method {} on osMxBean {}", (Object)method, (Object)osMxBean);
        if (method != null) {
            try {
                double load = (Double)method.invoke((Object)osMxBean, new Object[0]);
                if (load >= 0.0) {
                    return (short)(load * 100.0);
                }
            }
            catch (Exception e) {
                logger.debug(() -> "failed to invoke method [" + String.valueOf(method) + "] on osMxBean [" + String.valueOf(osMxBean) + "]", (Throwable)e);
                return -1;
            }
        }
        logger.debug("Method is null. Returning default value.");
        return -1;
    }
}

