/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldSyntheticWriterHelper;
import org.elasticsearch.xcontent.XContentBuilder;

class FlattenedSortedSetDocValuesSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String fieldFullPath;
    private final String keyedFieldFullPath;
    private final String keyedIgnoredValuesFieldFullPath;
    private final String leafName;
    private DocValuesFieldValues docValues = NO_VALUES;
    private List<Object> ignoredValues = List.of();
    private static final DocValuesFieldValues NO_VALUES = new DocValuesFieldValues(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public SortedSetDocValues getValues() {
            return null;
        }
    };

    FlattenedSortedSetDocValuesSyntheticFieldLoader(String fieldFullPath, String keyedFieldFullPath, @Nullable String keyedIgnoredValuesFieldFullPath, String leafName) {
        this.fieldFullPath = fieldFullPath;
        this.keyedFieldFullPath = keyedFieldFullPath;
        this.keyedIgnoredValuesFieldFullPath = keyedIgnoredValuesFieldFullPath;
        this.leafName = leafName;
    }

    @Override
    public String fieldName() {
        return this.fieldFullPath;
    }

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        if (this.keyedIgnoredValuesFieldFullPath == null) {
            return Stream.empty();
        }
        return Stream.of(Map.entry(this.keyedIgnoredValuesFieldFullPath, values -> {
            this.ignoredValues = new ArrayList<Object>();
            this.ignoredValues.addAll(values);
        }));
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        SortedSetDocValues dv = DocValues.getSortedSet((LeafReader)reader, (String)this.keyedFieldFullPath);
        if (dv.getValueCount() == 0L) {
            this.docValues = NO_VALUES;
            return null;
        }
        FlattenedFieldDocValuesLoader loader = new FlattenedFieldDocValuesLoader(dv);
        this.docValues = loader;
        return loader;
    }

    @Override
    public boolean hasValue() {
        return this.docValues.count() > 0 || !this.ignoredValues.isEmpty();
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (this.docValues.count() == 0 && this.ignoredValues.isEmpty()) {
            return;
        }
        FlattenedFieldSyntheticWriterHelper.SortedKeyedValues sortedKeyedValues = new DocValuesSortedKeyedValues(this.docValues);
        if (!this.ignoredValues.isEmpty()) {
            TreeSet<BytesRef> ignoredValuesSet = new TreeSet<BytesRef>();
            for (Object value : this.ignoredValues) {
                ignoredValuesSet.add((BytesRef)value);
            }
            this.ignoredValues = List.of();
            sortedKeyedValues = new DocValuesWithIgnoredSortedKeyedValues(sortedKeyedValues, ignoredValuesSet);
        }
        FlattenedFieldSyntheticWriterHelper writer = new FlattenedFieldSyntheticWriterHelper(sortedKeyedValues);
        b.startObject(this.leafName);
        writer.write(b);
        b.endObject();
    }

    @Override
    public void reset() {
        this.ignoredValues = List.of();
    }

    private static interface DocValuesFieldValues {
        public int count();

        public SortedSetDocValues getValues();
    }

    private static class FlattenedFieldDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    DocValuesFieldValues {
        private final SortedSetDocValues dv;
        private boolean hasValue;

        FlattenedFieldDocValuesLoader(SortedSetDocValues dv) {
            this.dv = dv;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.dv.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int count() {
            return this.hasValue ? this.dv.docValueCount() : 0;
        }

        @Override
        public SortedSetDocValues getValues() {
            return this.dv;
        }
    }

    private static class DocValuesSortedKeyedValues
    implements FlattenedFieldSyntheticWriterHelper.SortedKeyedValues {
        private final DocValuesFieldValues docValues;
        private int seen = 0;

        private DocValuesSortedKeyedValues(DocValuesFieldValues docValues) {
            this.docValues = docValues;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.seen < this.docValues.count()) {
                ++this.seen;
                SortedSetDocValues sortedSetDocValues = this.docValues.getValues();
                return sortedSetDocValues.lookupOrd(sortedSetDocValues.nextOrd());
            }
            return null;
        }
    }

    private static class DocValuesWithIgnoredSortedKeyedValues
    implements FlattenedFieldSyntheticWriterHelper.SortedKeyedValues {
        private final FlattenedFieldSyntheticWriterHelper.SortedKeyedValues docValues;
        private final TreeSet<BytesRef> ignoredValues;
        private BytesRef currentFromDocValues;

        private DocValuesWithIgnoredSortedKeyedValues(FlattenedFieldSyntheticWriterHelper.SortedKeyedValues docValues, TreeSet<BytesRef> ignoredValues) {
            this.docValues = docValues;
            this.ignoredValues = ignoredValues;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.currentFromDocValues == null) {
                this.currentFromDocValues = this.docValues.next();
            }
            if (!this.ignoredValues.isEmpty()) {
                BytesRef ignoredCandidate = this.ignoredValues.first();
                if (this.currentFromDocValues == null || ignoredCandidate.compareTo(this.currentFromDocValues) <= 0) {
                    this.ignoredValues.pollFirst();
                    return ignoredCandidate;
                }
            }
            if (this.currentFromDocValues == null) {
                return null;
            }
            BytesRef toReturn = this.currentFromDocValues;
            this.currentFromDocValues = null;
            return toReturn;
        }
    }
}

