/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DynamicFieldType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldParser;
import org.elasticsearch.index.mapper.flattened.FlattenedSortedSetDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.flattened.KeyedFlattenedLeafFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.FlattenedDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentParser;

public final class FlattenedFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "flattened";
    public static final String KEYED_FIELD_SUFFIX = "._keyed";
    public static final String KEYED_IGNORED_VALUES_FIELD_SUFFIX = "._keyed._ignored";
    public static final String TIME_SERIES_DIMENSIONS_ARRAY_PARAM = "time_series_dimensions";
    public static final FieldMapper.TypeParser PARSER = FlattenedFieldMapper.createTypeParserWithLegacySupport(Builder::new);
    private final FlattenedFieldParser fieldParser;
    private final Builder builder;

    private static Builder builder(Mapper in) {
        return ((FlattenedFieldMapper)in).builder;
    }

    private FlattenedFieldMapper(String leafName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(leafName, mappedFieldType, builderParams);
        this.builder = builder;
        this.fieldParser = new FlattenedFieldParser(mappedFieldType.name(), mappedFieldType.name() + KEYED_FIELD_SUFFIX, mappedFieldType.name() + KEYED_IGNORED_VALUES_FIELD_SUFFIX, mappedFieldType, builder.depthLimit.get(), builder.ignoreAbove.get(), builder.nullValue.get());
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    int depthLimit() {
        return this.builder.depthLimit.get();
    }

    @Override
    public RootFlattenedFieldType fieldType() {
        return (RootFlattenedFieldType)super.fieldType();
    }

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (!this.mappedFieldType.isIndexed() && !this.mappedFieldType.hasDocValues()) {
            context.parser().skipChildren();
            return;
        }
        try {
            context.path().setWithinLeafObject(true);
            List<IndexableField> fields = this.fieldParser.parse(context);
            context.doc().addAll(fields);
        }
        finally {
            context.path().setWithinLeafObject(false);
        }
        if (!this.mappedFieldType.hasDocValues()) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.builder.ignoreAboveDefault, this.builder.indexMode, this.builder.indexCreatedVersion).init(this);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.fieldType().hasDocValues()) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new FlattenedSortedSetDocValuesSyntheticFieldLoader(this.fullPath(), this.fullPath() + KEYED_FIELD_SUFFIX, this.fieldType().ignoreAbove.valuesPotentiallyIgnored() ? this.fullPath() + KEYED_IGNORED_VALUES_FIELD_SUFFIX : null, this.leafName()));
        }
        return super.syntheticSourceSupport();
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Integer> depthLimit = FieldMapper.Parameter.intParam("depth_limit", true, m -> FlattenedFieldMapper.builder((Mapper)m).depthLimit.get(), 20).addValidator(v -> {
            if (v < 0) {
                throw new IllegalArgumentException("[depth_limit] must be positive, got [" + v + "]");
            }
        });
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> FlattenedFieldMapper.builder((Mapper)m).indexed.get(), true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> FlattenedFieldMapper.builder((Mapper)m).hasDocValues.get(), true);
        private final FieldMapper.Parameter<String> nullValue = FieldMapper.Parameter.stringParam("null_value", false, m -> FlattenedFieldMapper.builder((Mapper)m).nullValue.get(), null).acceptsNull();
        private final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam("eager_global_ordinals", true, m -> FlattenedFieldMapper.builder((Mapper)m).eagerGlobalOrdinals.get(), false);
        private final int ignoreAboveDefault;
        private final FieldMapper.Parameter<Integer> ignoreAbove;
        private final FieldMapper.Parameter<String> indexOptions = TextParams.keywordIndexOptions(m -> FlattenedFieldMapper.builder((Mapper)m).indexOptions.get());
        private final FieldMapper.Parameter<SimilarityProvider> similarity = TextParams.similarity(m -> FlattenedFieldMapper.builder((Mapper)m).similarity.get());
        private final FieldMapper.Parameter<Boolean> splitQueriesOnWhitespace = FieldMapper.Parameter.boolParam("split_queries_on_whitespace", true, m -> FlattenedFieldMapper.builder((Mapper)m).splitQueriesOnWhitespace.get(), false);
        private final FieldMapper.Parameter<List<String>> dimensions = Builder.dimensionsParam(m -> FlattenedFieldMapper.builder((Mapper)m).dimensions.get()).addValidator(v -> {
            if (!(v.isEmpty() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                throw new IllegalArgumentException("Field [time_series_dimensions] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
            }
        });
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final IndexMode indexMode;
        private final IndexVersion indexCreatedVersion;

        public static FieldMapper.Parameter<List<String>> dimensionsParam(Function<FieldMapper, List<String>> initializer) {
            return FieldMapper.Parameter.stringArrayParam(FlattenedFieldMapper.TIME_SERIES_DIMENSIONS_ARRAY_PARAM, false, initializer);
        }

        public Builder(String name) {
            this(name, Mapper.IgnoreAbove.getIgnoreAboveDefaultValue(IndexMode.STANDARD, IndexVersion.current()), IndexMode.STANDARD, IndexVersion.current());
        }

        private Builder(String name, MappingParserContext mappingParserContext) {
            this(name, IndexSettings.IGNORE_ABOVE_SETTING.get(mappingParserContext.getSettings()), mappingParserContext.getIndexSettings().getMode(), mappingParserContext.indexVersionCreated());
        }

        private Builder(String name, int ignoreAboveDefault, IndexMode indexMode, IndexVersion indexCreatedVersion) {
            super(name);
            this.ignoreAboveDefault = ignoreAboveDefault;
            this.indexMode = indexMode;
            this.indexCreatedVersion = indexCreatedVersion;
            this.ignoreAbove = FieldMapper.Parameter.ignoreAboveParam(m -> FlattenedFieldMapper.builder((Mapper)m).ignoreAbove.get(), ignoreAboveDefault);
            this.dimensions.precludesParameters(this.ignoreAbove);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.depthLimit, this.nullValue, this.eagerGlobalOrdinals, this.ignoreAbove, this.indexOptions, this.similarity, this.splitQueriesOnWhitespace, this.meta, this.dimensions};
        }

        @Override
        public FlattenedFieldMapper build(MapperBuilderContext context) {
            FieldMapper.MultiFields multiFields = this.multiFieldsBuilder.build(this, context);
            if (multiFields.iterator().hasNext()) {
                throw new IllegalArgumentException("flattened field [" + this.leafName() + "] does not support [fields]");
            }
            if (!this.copyTo.copyToFields().isEmpty()) {
                throw new IllegalArgumentException("flattened field [" + this.leafName() + "] does not support [copy_to]");
            }
            RootFlattenedFieldType ft = new RootFlattenedFieldType(context.buildFullName(this.leafName()), this.indexed.get(), this.hasDocValues.get(), this.meta.get(), this.splitQueriesOnWhitespace.get(), this.eagerGlobalOrdinals.get(), this.dimensions.get(), new Mapper.IgnoreAbove(this.ignoreAbove.getValue(), this.indexMode, this.indexCreatedVersion));
            return new FlattenedFieldMapper(this.leafName(), ft, this.builderParams(this, context), this);
        }
    }

    public static final class RootFlattenedFieldType
    extends StringFieldType
    implements DynamicFieldType {
        private final boolean splitQueriesOnWhitespace;
        private final boolean eagerGlobalOrdinals;
        private final List<String> dimensions;
        private final boolean isDimension;
        private final Mapper.IgnoreAbove ignoreAbove;

        RootFlattenedFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta, boolean splitQueriesOnWhitespace, boolean eagerGlobalOrdinals, Mapper.IgnoreAbove ignoreAbove) {
            this(name, indexed, hasDocValues, meta, splitQueriesOnWhitespace, eagerGlobalOrdinals, Collections.emptyList(), ignoreAbove);
        }

        RootFlattenedFieldType(String name, boolean indexed, boolean hasDocValues, Map<String, String> meta, boolean splitQueriesOnWhitespace, boolean eagerGlobalOrdinals, List<String> dimensions, Mapper.IgnoreAbove ignoreAbove) {
            super(name, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.splitQueriesOnWhitespace = splitQueriesOnWhitespace;
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            this.dimensions = dimensions;
            this.isDimension = !dimensions.isEmpty();
            this.ignoreAbove = ignoreAbove;
        }

        @Override
        public String typeName() {
            return FlattenedFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean eagerGlobalOrdinals() {
            return this.eagerGlobalOrdinals;
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new FlattenedDocValuesField(FieldData.toString(dv), n));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet());
        }

        public Mapper.IgnoreAbove ignoreAbove() {
            return this.ignoreAbove;
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, null){

                @Override
                protected Object parseSourceValue(Object value) {
                    String valueAsString;
                    Map valueAsMap;
                    if (value instanceof Map && !(valueAsMap = (Map)value).isEmpty()) {
                        Map<String, Object> result = this.filterIgnoredValues(valueAsMap);
                        return result.isEmpty() ? null : result;
                    }
                    if (value instanceof String && !ignoreAbove.isIgnored(valueAsString = (String)value)) {
                        return valueAsString;
                    }
                    return null;
                }

                private Map<String, Object> filterIgnoredValues(Map<String, Object> values) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : values.entrySet()) {
                        Object value = this.filterIgnoredValues(entry.getValue());
                        if (value == null) continue;
                        result.put(entry.getKey(), value);
                    }
                    return result;
                }

                private Object filterIgnoredValues(Object entryValue) {
                    if (entryValue instanceof List) {
                        List valueAsList = (List)entryValue;
                        ArrayList<String> validValues = new ArrayList<String>();
                        for (Object value : valueAsList) {
                            if (value instanceof String) {
                                String valueAsString = (String)value;
                                if (ignoreAbove.isIgnored(valueAsString)) continue;
                                validValues.add(valueAsString);
                                continue;
                            }
                            validValues.add((String)value);
                        }
                        if (validValues.isEmpty()) {
                            return null;
                        }
                        if (validValues.size() == 1) {
                            return validValues.getFirst();
                        }
                        return validValues;
                    }
                    if (entryValue instanceof String) {
                        String valueAsString = (String)entryValue;
                        if (!ignoreAbove.isIgnored(valueAsString)) {
                            return valueAsString;
                        }
                        return null;
                    }
                    return entryValue;
                }
            };
        }

        @Override
        public MappedFieldType getChildFieldType(String childPath) {
            return new KeyedFlattenedFieldType(this.name(), childPath, this);
        }

        public MappedFieldType getKeyedFieldType() {
            return new KeywordFieldMapper.KeywordFieldType(this.name() + FlattenedFieldMapper.KEYED_FIELD_SUFFIX);
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public List<String> dimensions() {
            return this.dimensions;
        }

        @Override
        public void validateMatchedRoutingPath(String routingPath) {
            if (!this.dimensions.contains(routingPath)) {
                super.validateMatchedRoutingPath(routingPath);
            }
        }
    }

    public static class KeyedFlattenedFieldData
    implements IndexOrdinalsFieldData {
        private final String key;
        private final IndexOrdinalsFieldData delegate;
        private final ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory;

        private KeyedFlattenedFieldData(String key, IndexOrdinalsFieldData delegate, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) {
            this.delegate = delegate;
            this.key = key;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getFieldName() {
            return this.delegate.getFieldName();
        }

        @Override
        public ValuesSourceType getValuesSourceType() {
            return this.delegate.getValuesSourceType();
        }

        @Override
        public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
            BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }

        @Override
        public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
            throw new IllegalArgumentException("only supported on numeric fields");
        }

        @Override
        public LeafOrdinalsFieldData load(LeafReaderContext context) {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.load(context);
            return new KeyedFlattenedLeafFieldData(this.key, fieldData, this.toScriptFieldFactory);
        }

        @Override
        public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
            LeafOrdinalsFieldData fieldData = (LeafOrdinalsFieldData)this.delegate.loadDirect(context);
            return new KeyedFlattenedLeafFieldData(this.key, fieldData, this.toScriptFieldFactory);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobal(indexReader);
            return new KeyedFlattenedFieldData(this.key, fieldData, this.toScriptFieldFactory);
        }

        @Override
        public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) throws Exception {
            IndexOrdinalsFieldData fieldData = this.delegate.loadGlobalDirect(indexReader);
            return new KeyedFlattenedFieldData(this.key, fieldData, this.toScriptFieldFactory);
        }

        @Override
        public OrdinalMap getOrdinalMap() {
            throw new UnsupportedOperationException("The field data for the flattened field [" + this.delegate.getFieldName() + "] does not allow access to the underlying ordinal map.");
        }

        @Override
        public boolean supportsGlobalOrdinalsMapping() {
            return false;
        }

        public static class Builder
        implements IndexFieldData.Builder {
            private final String fieldName;
            private final String key;
            private final ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory;

            Builder(String fieldName, String key, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) {
                this.fieldName = fieldName;
                this.key = key;
                this.toScriptFieldFactory = toScriptFieldFactory;
            }

            @Override
            public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
                SortedSetOrdinalsIndexFieldData delegate = new SortedSetOrdinalsIndexFieldData(cache, this.fieldName, CoreValuesSourceType.KEYWORD, breakerService, (dv, n) -> {
                    throw new UnsupportedOperationException();
                });
                return new KeyedFlattenedFieldData(this.key, delegate, this.toScriptFieldFactory);
            }
        }
    }

    static class TranslatingTermsEnum
    extends TermsEnum {
        TermsEnum delegate;

        TranslatingTermsEnum(TermsEnum delegate) {
            this.delegate = delegate;
        }

        public BytesRef next() throws IOException {
            BytesRef result = this.delegate.next();
            if (result != null) {
                result = FlattenedFieldParser.extractValue(result);
            }
            return result;
        }

        public BytesRef term() throws IOException {
            BytesRef result = this.delegate.term();
            if (result != null) {
                result = FlattenedFieldParser.extractValue(result);
            }
            return result;
        }

        public int docFreq() throws IOException {
            return this.delegate.docFreq();
        }

        public AttributeSource attributes() {
            throw new UnsupportedOperationException();
        }

        public IOBooleanSupplier prepareSeekExact(BytesRef bytesRef) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean seekExact(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TermState termState() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static final class KeyedFlattenedFieldType
    extends StringFieldType {
        private final String key;
        private final String rootName;
        private final boolean isDimension;

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        KeyedFlattenedFieldType(String rootName, boolean indexed, boolean hasDocValues, String key, boolean splitQueriesOnWhitespace, Map<String, String> meta, boolean isDimension) {
            super(rootName + FlattenedFieldMapper.KEYED_FIELD_SUFFIX, indexed, false, hasDocValues, splitQueriesOnWhitespace ? TextSearchInfo.WHITESPACE_MATCH_ONLY : TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.key = key;
            this.rootName = rootName;
            this.isDimension = isDimension;
        }

        private KeyedFlattenedFieldType(String rootName, String key, RootFlattenedFieldType ref) {
            this(rootName, ref.isIndexed(), ref.hasDocValues(), key, ref.splitQueriesOnWhitespace, ref.meta(), ref.dimensions.contains(key));
        }

        @Override
        public String typeName() {
            return FlattenedFieldMapper.CONTENT_TYPE;
        }

        public String rootName() {
            return this.rootName;
        }

        public String key() {
            return this.key;
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            Term term = new Term(this.name(), FlattenedFieldParser.createKeyedValue(this.key, ""));
            return new PrefixQuery(term);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            if (lowerTerm == null || upperTerm == null) {
                throw new IllegalArgumentException("[range] queries on keyed [flattened] fields must include both an upper and a lower bound.");
            }
            return super.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, context);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, @Nullable MultiTermQuery.RewriteMethod rewriteMethod) {
            throw new UnsupportedOperationException("[fuzzy] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, MultiTermQuery.RewriteMethod method, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[regexp] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query wildcardQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, SearchExecutionContext context) {
            throw new UnsupportedOperationException("[wildcard] queries are not currently supported on keyed [flattened] fields.");
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, SearchExecutionContext context) {
            return AutomatonQueries.caseInsensitiveTermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        }

        @Override
        public TermsEnum getTerms(IndexReader reader, String prefix, boolean caseInsensitive, String searchAfter) throws IOException {
            Terms terms = MultiTerms.getTerms((IndexReader)reader, (String)this.name());
            if (terms == null) {
                return null;
            }
            Automaton a = Automata.makeString((String)(this.key + "\u0000"));
            if (caseInsensitive) {
                a = Operations.concatenate((Automaton)a, (Automaton)AutomatonQueries.caseInsensitivePrefix(prefix));
            } else {
                a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeString((String)prefix));
                a = Operations.concatenate((Automaton)a, (Automaton)Automata.makeAnyString());
            }
            assert (a.isDeterministic());
            CompiledAutomaton automaton = new CompiledAutomaton(a);
            if (searchAfter != null) {
                BytesRef searchAfterWithFieldName = new BytesRef((CharSequence)(this.key + "\u0000" + searchAfter));
                TermsEnum seekedEnum = terms.intersect(automaton, searchAfterWithFieldName);
                return new TranslatingTermsEnum(seekedEnum);
            }
            return new TranslatingTermsEnum(automaton.getTermsEnum(terms));
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return null;
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            String keyedValue = FlattenedFieldParser.createKeyedValue(this.key, stringValue);
            return new BytesRef((CharSequence)keyedValue);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new KeyedFlattenedFieldData.Builder(this.name(), this.key, (dv, n) -> new FlattenedDocValuesField(FieldData.toString(dv), n));
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.rootName + "." + this.key + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return SourceValueFetcher.identity(this.rootName + "." + this.key, context, null);
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    private static class Defaults {
        public static final int DEPTH_LIMIT = 20;

        private Defaults() {
        }
    }
}

