/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.MergeInfo;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.codec.vectors.AbstractFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.MergeReaderWrapper;
import org.elasticsearch.index.codec.vectors.es818.DirectIOHint;
import org.elasticsearch.index.store.FsDirectoryFactory;

public class DirectIOLucene99FlatVectorsFormat
extends AbstractFlatVectorsFormat {
    static final String NAME = "Lucene99FlatVectorsFormat";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    private final FlatVectorsScorer vectorsScorer;

    public DirectIOLucene99FlatVectorsFormat(FlatVectorsScorer vectorsScorer) {
        super(NAME);
        this.vectorsScorer = vectorsScorer;
    }

    @Override
    protected FlatVectorsScorer flatVectorsScorer() {
        return this.vectorsScorer;
    }

    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99FlatVectorsWriter(state, this.vectorsScorer);
    }

    static boolean shouldUseDirectIO(SegmentReadState state) {
        assert (USE_DIRECT_IO);
        return FsDirectoryFactory.isHybridFs(state.directory);
    }

    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        if (DirectIOLucene99FlatVectorsFormat.shouldUseDirectIO(state) && state.context.context() == IOContext.Context.DEFAULT) {
            SegmentReadState directIOState = new SegmentReadState(state.directory, state.segmentInfo, state.fieldInfos, (IOContext)new DirectIOContext(state.context.hints()), state.segmentSuffix);
            return new MergeReaderWrapper((FlatVectorsReader)new Lucene99FlatVectorsReader(directIOState, this.vectorsScorer), (FlatVectorsReader)new Lucene99FlatVectorsReader(state, this.vectorsScorer));
        }
        return new Lucene99FlatVectorsReader(state, this.vectorsScorer);
    }

    static class DirectIOContext
    implements IOContext {
        final Set<IOContext.FileOpenHint> hints;

        DirectIOContext(Set<IOContext.FileOpenHint> hints) {
            this.hints = Sets.union(hints, Set.of(DirectIOHint.INSTANCE));
        }

        public IOContext.Context context() {
            return IOContext.Context.DEFAULT;
        }

        public MergeInfo mergeInfo() {
            return null;
        }

        public FlushInfo flushInfo() {
            return null;
        }

        public Set<IOContext.FileOpenHint> hints() {
            return this.hints;
        }

        public IOContext withHints(IOContext.FileOpenHint ... hints) {
            return new DirectIOContext(Set.of(hints));
        }
    }
}

