/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.diskbbq;

import java.io.IOException;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.index.codec.vectors.OptimizedScalarQuantizer;
import org.elasticsearch.index.codec.vectors.diskbbq.QuantizedVectorValues;

abstract class DiskBBQBulkWriter {
    protected final int bulkSize;
    protected final IndexOutput out;

    protected DiskBBQBulkWriter(int bulkSize, IndexOutput out) {
        this.bulkSize = bulkSize;
        this.out = out;
    }

    abstract void writeVectors(QuantizedVectorValues var1, CheckedIntConsumer<IOException> var2) throws IOException;

    static class SevenBitDiskBBQBulkWriter
    extends DiskBBQBulkWriter {
        private final OptimizedScalarQuantizer.QuantizationResult[] corrections;

        SevenBitDiskBBQBulkWriter(int bulkSize, IndexOutput out) {
            super(bulkSize, out);
            this.corrections = new OptimizedScalarQuantizer.QuantizationResult[bulkSize];
        }

        @Override
        void writeVectors(QuantizedVectorValues qvv, CheckedIntConsumer<IOException> docsWriter) throws IOException {
            int i;
            int limit = qvv.count() - this.bulkSize + 1;
            for (i = 0; i < limit; i += this.bulkSize) {
                for (int j = 0; j < this.bulkSize; ++j) {
                    byte[] qv = qvv.next();
                    this.corrections[j] = qvv.getCorrections();
                    this.out.writeBytes(qv, qv.length);
                }
                this.writeCorrections(this.corrections);
            }
            while (i < qvv.count()) {
                byte[] qv = qvv.next();
                OptimizedScalarQuantizer.QuantizationResult correction = qvv.getCorrections();
                this.out.writeBytes(qv, qv.length);
                this.writeCorrection(correction);
                ++i;
            }
        }

        private void writeCorrections(OptimizedScalarQuantizer.QuantizationResult[] corrections) throws IOException {
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.lowerInterval()));
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.upperInterval()));
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(correction.quantizedComponentSum());
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.additionalCorrection()));
            }
        }

        private void writeCorrection(OptimizedScalarQuantizer.QuantizationResult correction) throws IOException {
            this.out.writeInt(Float.floatToIntBits(correction.lowerInterval()));
            this.out.writeInt(Float.floatToIntBits(correction.upperInterval()));
            this.out.writeInt(Float.floatToIntBits(correction.additionalCorrection()));
            this.out.writeInt(correction.quantizedComponentSum());
        }
    }

    static class OneBitDiskBBQBulkWriter
    extends DiskBBQBulkWriter {
        private final OptimizedScalarQuantizer.QuantizationResult[] corrections;

        OneBitDiskBBQBulkWriter(int bulkSize, IndexOutput out) {
            super(bulkSize, out);
            this.corrections = new OptimizedScalarQuantizer.QuantizationResult[bulkSize];
        }

        @Override
        void writeVectors(QuantizedVectorValues qvv, CheckedIntConsumer<IOException> docsWriter) throws IOException {
            int i;
            int limit = qvv.count() - this.bulkSize + 1;
            for (i = 0; i < limit; i += this.bulkSize) {
                if (docsWriter != null) {
                    docsWriter.accept(i);
                }
                for (int j = 0; j < this.bulkSize; ++j) {
                    byte[] qv = qvv.next();
                    this.corrections[j] = qvv.getCorrections();
                    this.out.writeBytes(qv, qv.length);
                }
                this.writeCorrections(this.corrections);
            }
            if (i < qvv.count() && docsWriter != null) {
                docsWriter.accept(i);
            }
            while (i < qvv.count()) {
                byte[] qv = qvv.next();
                OptimizedScalarQuantizer.QuantizationResult correction = qvv.getCorrections();
                this.out.writeBytes(qv, qv.length);
                this.writeCorrection(correction);
                ++i;
            }
        }

        private void writeCorrections(OptimizedScalarQuantizer.QuantizationResult[] corrections) throws IOException {
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.lowerInterval()));
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.upperInterval()));
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                int targetComponentSum = correction.quantizedComponentSum();
                assert (targetComponentSum >= 0 && targetComponentSum <= 65535);
                this.out.writeShort((short)targetComponentSum);
            }
            for (OptimizedScalarQuantizer.QuantizationResult correction : corrections) {
                this.out.writeInt(Float.floatToIntBits(correction.additionalCorrection()));
            }
        }

        private void writeCorrection(OptimizedScalarQuantizer.QuantizationResult correction) throws IOException {
            this.out.writeInt(Float.floatToIntBits(correction.lowerInterval()));
            this.out.writeInt(Float.floatToIntBits(correction.upperInterval()));
            this.out.writeInt(Float.floatToIntBits(correction.additionalCorrection()));
            int targetComponentSum = correction.quantizedComponentSum();
            assert (targetComponentSum >= 0 && targetComponentSum <= 65535);
            this.out.writeShort((short)targetComponentSum);
        }
    }
}

