/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Optional;
import org.elasticsearch.common.CheckedSupplier;

public abstract class Result<V, E extends Exception>
implements CheckedSupplier<V, E> {
    public static <V, E extends Exception> Result<V, E> of(V value) {
        return new Success(value);
    }

    public static <V, E extends Exception> Result<V, E> failure(E exception) {
        return new Failure(exception);
    }

    private Result() {
    }

    @Override
    public abstract V get() throws E;

    public abstract Optional<E> failure();

    public abstract boolean isSuccessful();

    public boolean isFailure() {
        return !this.isSuccessful();
    }

    public abstract Optional<V> asOptional();

    private static class Success<V, E extends Exception>
    extends Result<V, E> {
        private final V value;

        Success(V value) {
            this.value = value;
        }

        @Override
        public V get() throws E {
            return this.value;
        }

        @Override
        public Optional<E> failure() {
            return Optional.empty();
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public Optional<V> asOptional() {
            return Optional.of(this.value);
        }
    }

    private static class Failure<V, E extends Exception>
    extends Result<V, E> {
        private final E exception;

        Failure(E exception) {
            this.exception = exception;
        }

        @Override
        public V get() throws E {
            throw this.exception;
        }

        @Override
        public Optional<E> failure() {
            return Optional.of(this.exception);
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public Optional<V> asOptional() {
            return Optional.empty();
        }
    }
}

