/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;

public interface VersionedNamedWriteable
extends NamedWriteable {
    @Override
    public String getWriteableName();

    public TransportVersion getMinimalSupportedVersion();

    default public boolean supportsVersion(TransportVersion version) {
        return version.onOrAfter(this.getMinimalSupportedVersion());
    }

    public static <T extends VersionedNamedWriteable> void writeVersionedWritables(StreamOutput out, Map<String, T> customs) throws IOException {
        VersionedNamedWriteable.writeVersionedWriteables(out, customs.values());
    }

    public static void writeVersionedWriteables(StreamOutput out, Iterable<? extends VersionedNamedWriteable> writeables) throws IOException {
        int numberOfCompatibleValues = 0;
        for (VersionedNamedWriteable versionedNamedWriteable : writeables) {
            if (!versionedNamedWriteable.supportsVersion(out.getTransportVersion())) continue;
            ++numberOfCompatibleValues;
        }
        out.writeVInt(numberOfCompatibleValues);
        for (VersionedNamedWriteable versionedNamedWriteable : writeables) {
            if (!versionedNamedWriteable.supportsVersion(out.getTransportVersion())) continue;
            out.writeNamedWriteable(versionedNamedWriteable);
        }
    }
}

