/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Predicates;

public class DataStreamFailureStoreSettings {
    private static final Logger logger = LogManager.getLogger(DataStreamFailureStoreSettings.class);
    public static final Setting<List<String>> DATA_STREAM_FAILURE_STORED_ENABLED_SETTING = Setting.stringListSetting("data_streams.failure_store.enabled", Setting.Property.Dynamic, Setting.Property.NodeScope);
    private Predicate<String> failureStoreEnabledByName = Predicates.never();

    private DataStreamFailureStoreSettings() {
    }

    public static DataStreamFailureStoreSettings create(ClusterSettings clusterSettings) {
        DataStreamFailureStoreSettings dataStreamFailureStoreSettings = new DataStreamFailureStoreSettings();
        clusterSettings.initializeAndWatch(DATA_STREAM_FAILURE_STORED_ENABLED_SETTING, dataStreamFailureStoreSettings::setEnabledByNamePatterns);
        return dataStreamFailureStoreSettings;
    }

    public boolean failureStoreEnabledForDataStreamName(String name) {
        return this.failureStoreEnabledByName.test(name);
    }

    private void setEnabledByNamePatterns(List<String> patterns) {
        this.failureStoreEnabledByName = Regex.simpleMatcher((String[])patterns.toArray(String[]::new));
        logger.info("Updated data stream name patterns for enabling failure store to [{}]", patterns);
    }
}

