/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;

public abstract class SimpleBatchedAckListenerTaskExecutor<Task extends ClusterStateTaskListener>
implements ClusterStateTaskExecutor<Task> {
    public abstract Tuple<ClusterState, ClusterStateAckListener> executeTask(Task var1, ClusterState var2) throws Exception;

    public ClusterState afterBatchExecution(ClusterState clusterState, boolean clusterStateChanged) {
        return clusterState;
    }

    @Override
    public final void clusterStatePublished(ClusterState newClusterState) {
        this.clusterStatePublished();
    }

    public void clusterStatePublished() {
    }

    @Override
    public final ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<Task> batchExecutionContext) throws Exception {
        ClusterState initState;
        ClusterState clusterState = initState = batchExecutionContext.initialState();
        for (ClusterStateTaskExecutor.TaskContext<Task> taskContext : batchExecutionContext.taskContexts()) {
            try {
                Releasable ignored = taskContext.captureResponseHeaders();
                try {
                    Task task = taskContext.getTask();
                    Tuple<ClusterState, ClusterStateAckListener> result = this.executeTask(task, clusterState);
                    clusterState = (ClusterState)result.v1();
                    taskContext.success((ClusterStateAckListener)result.v2());
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                taskContext.onFailure(e);
            }
        }
        try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
            ClusterState clusterState2 = this.afterBatchExecution(clusterState, clusterState != initState);
            return clusterState2;
        }
    }
}

