/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;

public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;
    private final ProjectsDelta projectsDelta;

    public ClusterChangedEvent(String source, ClusterState state, ClusterState previousState) {
        Objects.requireNonNull(source, "source must not be null");
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(previousState, "previousState must not be null");
        this.source = source;
        this.state = state;
        this.previousState = previousState;
        this.nodesDelta = state.nodes().delta(previousState.nodes());
        this.projectsDelta = ClusterChangedEvent.calculateProjectDelta(previousState.metadata(), state.metadata());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.globalRoutingTable() != this.previousState.globalRoutingTable();
    }

    public boolean indexRoutingTableChanged(Index index) {
        Objects.requireNonNull(index, "index must not be null");
        Optional<IndexRoutingTable> indexRoutingTable = this.state.globalRoutingTable().indexRouting(this.state.metadata(), index);
        Optional<IndexRoutingTable> previousIndexRoutingTable = this.previousState.globalRoutingTable().indexRouting(this.previousState.metadata(), index);
        if (indexRoutingTable.isEmpty() || previousIndexRoutingTable.isEmpty()) {
            return indexRoutingTable.isEmpty() != previousIndexRoutingTable.isEmpty();
        }
        return indexRoutingTable.get() != previousIndexRoutingTable.get();
    }

    public List<Index> indicesDeleted() {
        if (this.previousState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return this.indicesDeletedFromTombstones();
        }
        return this.indicesDeletedFromClusterState();
    }

    public boolean metadataChanged() {
        return this.state.metadata() != this.previousState.metadata();
    }

    public Set<String> changedCustomClusterMetadataSet() {
        return this.changedCustoms(this.state.metadata().customs(), this.previousState.metadata().customs());
    }

    public Set<String> changedCustomProjectMetadataSet() {
        HashSet<String> result = new HashSet<String>();
        for (ProjectMetadata project : this.state.metadata().projects().values()) {
            ProjectMetadata previousProject = this.previousState.metadata().projects().get(project.id());
            if (previousProject == null) {
                result.addAll(project.customs().keySet());
                continue;
            }
            result.addAll(this.changedCustoms(project.customs(), previousProject.customs()));
        }
        for (ProjectMetadata previousProject : this.previousState.metadata().projects().values()) {
            ProjectMetadata project = this.state.metadata().projects().get(previousProject.id());
            if (project != null) continue;
            result.addAll(previousProject.customs().keySet());
        }
        return result;
    }

    public boolean customMetadataChanged(ProjectId projectId, String customMetadataType) {
        ProjectMetadata previousProject = this.previousState.metadata().projects().get(projectId);
        ProjectMetadata project = this.state.metadata().projects().get(projectId);
        Metadata.ProjectCustom previousValue = previousProject == null ? null : previousProject.customs().get(customMetadataType);
        Metadata.ProjectCustom value = project == null ? null : project.customs().get(customMetadataType);
        return !Objects.equals(previousValue, value);
    }

    private <C extends Metadata.MetadataCustom<C>> Set<String> changedCustoms(Map<String, C> currentCustoms, Map<String, C> previousCustoms) {
        HashSet<String> result = new HashSet<String>();
        if (!currentCustoms.equals(previousCustoms)) {
            for (Map.Entry<String, C> currentCustomMetadata : currentCustoms.entrySet()) {
                if (previousCustoms.containsKey(currentCustomMetadata.getKey()) && ((Metadata.MetadataCustom)currentCustomMetadata.getValue()).equals(previousCustoms.get(currentCustomMetadata.getKey()))) continue;
                result.add(currentCustomMetadata.getKey());
            }
            for (Map.Entry<String, C> previousCustomMetadata : previousCustoms.entrySet()) {
                if (currentCustoms.containsKey(previousCustomMetadata.getKey())) continue;
                result.add(previousCustomMetadata.getKey());
            }
        }
        return result;
    }

    public static boolean indexMetadataChanged(IndexMetadata metadata1, IndexMetadata metadata2) {
        assert (metadata1 != null && metadata2 != null);
        return metadata1 != metadata2;
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeMaster() {
        return this.state.nodes().isLocalNodeElectedMaster();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }

    public ProjectsDelta projectDelta() {
        return this.projectsDelta;
    }

    public boolean isNewCluster() {
        String currClusterUUID;
        String prevClusterUUID = this.previousState.metadata().clusterUUID();
        return !prevClusterUUID.equals(currClusterUUID = this.state.metadata().clusterUUID());
    }

    private List<Index> indicesDeletedFromClusterState() {
        if (!this.metadataChanged() || this.isNewCluster()) {
            return Collections.emptyList();
        }
        HashSet<Index> deleted = null;
        Metadata previousMetadata = this.previousState.metadata();
        Metadata currentMetadata = this.state.metadata();
        for (ProjectMetadata project : currentMetadata.projects().values()) {
            IndexGraveyard.IndexGraveyardDiff indexGraveyardDiff;
            List<IndexGraveyard.Tombstone> added;
            IndexGraveyard previousGraveyard;
            IndexGraveyard currentGraveyard;
            ProjectMetadata previousProject = previousMetadata.projects().get(project.id());
            if (previousProject == null) continue;
            if (project.indices() != previousProject.indices()) {
                for (IndexMetadata index : previousProject.indices().values()) {
                    IndexMetadata current = project.index(index.getIndex());
                    if (current != null) continue;
                    if (deleted == null) {
                        deleted = new HashSet();
                    }
                    deleted.add(index.getIndex());
                }
            }
            if ((currentGraveyard = project.indexGraveyard()) == (previousGraveyard = previousProject.indexGraveyard()) || (added = (indexGraveyardDiff = (IndexGraveyard.IndexGraveyardDiff)currentGraveyard.diff(previousGraveyard)).getAdded()).isEmpty()) continue;
            if (deleted == null) {
                deleted = new HashSet();
            }
            for (IndexGraveyard.Tombstone tombstone : added) {
                deleted.add(tombstone.getIndex());
            }
        }
        for (ProjectMetadata previousProject : previousMetadata.projects().values()) {
            if (currentMetadata.projects().containsKey(previousProject.id())) continue;
            for (IndexMetadata index : previousProject.indices().values()) {
                if (deleted == null) {
                    deleted = new HashSet<Index>();
                }
                deleted.add(index.getIndex());
            }
        }
        return deleted == null ? Collections.emptyList() : new ArrayList(deleted);
    }

    private List<Index> indicesDeletedFromTombstones() {
        return this.state.metadata().projects().values().stream().flatMap(project -> project.indexGraveyard().getTombstones().stream().map(IndexGraveyard.Tombstone::getIndex)).toList();
    }

    private static ProjectsDelta calculateProjectDelta(Metadata previousMetadata, Metadata currentMetadata) {
        if (previousMetadata == currentMetadata || previousMetadata.projects().size() == 1 && previousMetadata.hasProject(ProjectId.DEFAULT) && currentMetadata.projects().size() == 1 && currentMetadata.hasProject(ProjectId.DEFAULT)) {
            return ProjectsDelta.EMPTY;
        }
        Set<ProjectId> added = Collections.unmodifiableSet(Sets.difference(currentMetadata.projects().keySet(), previousMetadata.projects().keySet()));
        Set<ProjectId> removed = Collections.unmodifiableSet(Sets.difference(previousMetadata.projects().keySet(), currentMetadata.projects().keySet()));
        return new ProjectsDelta(added, removed);
    }

    public record ProjectsDelta(Set<ProjectId> added, Set<ProjectId> removed) {
        private static final ProjectsDelta EMPTY = new ProjectsDelta(Set.of(), Set.of());

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }
    }
}

