/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class GetIndexRequest
extends LocalClusterStateRequest
implements IndicesRequest.Replaceable {
    static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS};
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions;
    private Feature[] features = DEFAULT_FEATURES;
    private boolean humanReadable = false;
    private transient boolean includeDefaults = false;

    public GetIndexRequest(TimeValue masterTimeout) {
        super(masterTimeout);
        this.indicesOptions = IndicesOptions.strictExpandOpen();
    }

    public GetIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readStringArray();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.features = in.readArray(i -> Feature.fromId(i.readByte()), Feature[]::new);
        this.humanReadable = in.readBoolean();
        this.includeDefaults = in.readBoolean();
    }

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new IllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... features) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(features);
        }
        return this.features(ArrayUtils.concat(this.features(), features));
    }

    public Feature[] features() {
        return this.features;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public GetIndexRequest humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public GetIndexRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Override
    public GetIndexRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public GetIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public static final class Feature
    extends Enum<Feature> {
        public static final /* enum */ Feature ALIASES = new Feature(0);
        public static final /* enum */ Feature MAPPINGS = new Feature(1);
        public static final /* enum */ Feature SETTINGS = new Feature(2);
        private static final Feature[] FEATURES;
        private final byte id;
        private static final /* synthetic */ Feature[] $VALUES;

        public static Feature[] values() {
            return (Feature[])$VALUES.clone();
        }

        public static Feature valueOf(String name) {
            return Enum.valueOf(Feature.class, name);
        }

        private Feature(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Feature fromId(byte id) {
            if (id < 0 || id >= FEATURES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return FEATURES[id];
        }

        public static Feature[] fromRequest(RestRequest request) {
            if (request.hasParam("features")) {
                String[] featureNames = request.param("features").split(",");
                EnumSet<Feature> features = EnumSet.noneOf(Feature.class);
                ArrayList<String> invalidFeatures = new ArrayList<String>();
                for (int k = 0; k < featureNames.length; ++k) {
                    try {
                        features.add(Feature.valueOf(featureNames[k].toUpperCase(Locale.ROOT)));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        invalidFeatures.add(featureNames[k]);
                    }
                }
                if (invalidFeatures.size() > 0) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid features specified [%s]", String.join((CharSequence)",", invalidFeatures)));
                }
                return (Feature[])features.toArray(Feature[]::new);
            }
            return DEFAULT_FEATURES;
        }

        private static /* synthetic */ Feature[] $values() {
            return new Feature[]{ALIASES, MAPPINGS, SETTINGS};
        }

        static {
            $VALUES = Feature.$values();
            FEATURES = new Feature[Feature.values().length];
            for (Feature feature : Feature.values()) {
                assert (feature.id() < FEATURES.length && feature.id() >= 0);
                Feature.FEATURES[feature.id] = feature;
            }
        }
    }
}

