/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianShapeDocValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGroupingState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("minX", ElementType.INT), new IntermediateStateDesc("maxX", ElementType.INT), new IntermediateStateDesc("maxY", ElementType.INT), new IntermediateStateDesc("minY", ElementType.INT));
    private final SpatialExtentGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction(List<Integer> channels, SpatialExtentGroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction(channels, SpatialExtentCartesianShapeDocValuesAggregator.initGrouping(), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final IntBlock valuesBlock = (IntBlock)page.getBlock(this.channels.get(0));
        final IntVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valuesBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialExtentCartesianShapeDocValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntBlock valuesBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valuesBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                SpatialExtentCartesianShapeDocValuesAggregator.combine(this.state, groupId, valuesPosition, valuesBlock);
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, IntVector valuesVector) {
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentCartesianShapeDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntBlock valuesBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valuesBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                SpatialExtentCartesianShapeDocValuesAggregator.combine(this.state, groupId, valuesPosition, valuesBlock);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, IntVector valuesVector) {
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentCartesianShapeDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntBlock valuesBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valuesBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            SpatialExtentCartesianShapeDocValuesAggregator.combine(this.state, groupId, valuesPosition, valuesBlock);
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, IntVector valuesVector) {
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minX.getPositionCount() == maxX.getPositionCount() && minX.getPositionCount() == maxY.getPositionCount() && minX.getPositionCount() == minY.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SpatialExtentCartesianShapeDocValuesAggregator.combineIntermediate(this.state, groupId, minX.getInt(valuesPosition), maxX.getInt(valuesPosition), maxY.getInt(valuesPosition), minY.getInt(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, IntBlock valuesBlock) {
        if (valuesBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SpatialExtentCartesianShapeDocValuesAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

