/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import org.ojalgo.algebra.Field;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.structure.AccessScalar;
import org.ojalgo.tensor.Tensor;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public interface Scalar<N extends Comparable<N>>
extends AccessScalar<N>,
Field<Scalar<N>>,
ScalarOperation.Addition<Scalar<N>, N>,
ScalarOperation.Division<Scalar<N>, N>,
ScalarOperation.Subtraction<Scalar<N>, N>,
Comparable<N>,
Tensor<N, Scalar<N>> {
    public static boolean booleanValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.booleanValue(number);
        }
        return false;
    }

    public static byte byteValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.byteValue(number);
        }
        return 0;
    }

    public static double doubleValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.doubleValue(number);
        }
        return 0.0;
    }

    public static float floatValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.floatValue(number);
        }
        return 0.0f;
    }

    public static int intValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.intValue(number);
        }
        return 0;
    }

    public static long longValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.longValue(number);
        }
        return 0L;
    }

    public static short shortValue(Comparable<?> number) {
        if (number != null) {
            return NumberDefinition.shortValue(number);
        }
        return 0;
    }

    @Override
    default public Scalar<N> add(Scalar<N> addend) {
        return (Scalar)this.add((Comparable)addend.get());
    }

    @Override
    default public int dimensions() {
        return 1;
    }

    @Override
    default public Scalar<N> divide(Scalar<N> divisor) {
        return (Scalar)this.divide((Comparable)divisor.get());
    }

    public boolean isAbsolute();

    @Override
    default public Scalar<N> multiply(Scalar<N> multiplicand) {
        return (Scalar)this.multiply((Comparable)multiplicand.get());
    }

    @Override
    default public int rank() {
        return 0;
    }

    @Override
    default public Scalar<N> subtract(Scalar<N> subtrahend) {
        return (Scalar)this.subtract((Comparable)subtrahend.get());
    }

    public BigDecimal toBigDecimal();

    default public String toPlainString(NumberContext context) {
        return context.enforce(this.toBigDecimal()).toPlainString();
    }

    public String toString(NumberContext var1);

    public static interface Factory<N extends Comparable<N>> {
        public N cast(Comparable<?> var1);

        public N cast(double var1);

        public Scalar<N> convert(Comparable<?> var1);

        public Scalar<N> convert(double var1);

        default public N[] newArrayInstance(int length) {
            return (Comparable[])Array.newInstance(((Comparable)this.zero().get()).getClass(), length);
        }

        public Scalar<N> one();

        public Scalar<N> zero();
    }
}

