/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.netio.BasicParser;

public class YahooParser
implements BasicParser<Data> {
    @Override
    public Data parse(String line) throws RecoverableCondition {
        Data retVal = null;
        try {
            int inclBegin = 0;
            int exclEnd = line.indexOf(44, inclBegin);
            String part = line.substring(inclBegin, exclEnd);
            retVal = new Data(part);
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                retVal.open = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                retVal.high = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.high = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                retVal.low = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.low = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                retVal.close = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.close = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            exclEnd = line.indexOf(44, inclBegin);
            part = line.substring(inclBegin, exclEnd);
            try {
                retVal.adjustedClose = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.adjustedClose = Double.NaN;
            }
            inclBegin = exclEnd + 1;
            part = line.substring(inclBegin);
            try {
                retVal.volume = Double.parseDouble(part);
            }
            catch (NumberFormatException ex) {
                retVal.volume = Double.NaN;
            }
        }
        catch (Exception exception) {
            retVal = null;
        }
        return retVal;
    }

    public static final class Data
    extends DatePrice {
        public double adjustedClose;
        public double close;
        public double high;
        public double low;
        public double open;
        public double volume;

        public Data(LocalDate date) {
            super(date);
        }

        Data(CharSequence text) {
            super(text);
        }

        Data(CharSequence text, DateTimeFormatter formatter) {
            super(text, formatter);
        }

        @Override
        public double getPrice() {
            return this.adjustedClose;
        }
    }
}

