/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ConstantLongVector;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongArrayVector;
import org.elasticsearch.compute.data.LongBigArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVectorBuilder;
import org.elasticsearch.compute.data.LongVectorFixedBuilder;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

public sealed interface LongVector
extends Vector
permits ConstantLongVector, LongArrayVector, LongBigArrayVector, ConstantNullVector {
    public long getLong(int var1);

    @Override
    public LongBlock asBlock();

    @Override
    public LongVector filter(int ... var1);

    @Override
    public LongBlock keepMask(BooleanVector var1);

    @Override
    default public LongVector deepCopy(BlockFactory blockFactory) {
        try (LongBlock.Builder builder = blockFactory.newLongBlockBuilder(this.getPositionCount());){
            builder.copyFrom(this.asBlock(), 0, this.getPositionCount());
            builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
            LongVector longVector = builder.build().asVector();
            return longVector;
        }
    }

    public ReleasableIterator<? extends LongBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(LongVector vector1, LongVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getLong(pos) == vector2.getLong(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(LongVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            long element = vector.getLong(pos);
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    public static LongVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> LongVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantLongVector(in.readLong(), positions);
            case 2 -> LongArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> LongBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeLong(this.getLong(0));
        } else {
            LongVector longVector = this;
            if (longVector instanceof LongArrayVector) {
                LongArrayVector v = (LongArrayVector)longVector;
                out.writeByte((byte)2);
                v.writeArrayVector(positions, out);
            } else {
                longVector = this;
                if (longVector instanceof LongBigArrayVector) {
                    LongBigArrayVector v = (LongBigArrayVector)longVector;
                    out.writeByte((byte)3);
                    v.writeArrayVector(positions, out);
                } else {
                    out.writeByte((byte)0);
                    LongVector.writeValues(this, positions, out);
                }
            }
        }
    }

    private static LongVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newLongVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendLong(i, in.readLong());
            }
            LongVector longVector = builder.build();
            return longVector;
        }
    }

    private static void writeValues(LongVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeLong(v.getLong(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static sealed interface FixedBuilder
    extends Builder
    permits LongVectorFixedBuilder {
        @Override
        public FixedBuilder appendLong(long var1);

        public FixedBuilder appendLong(int var1, long var2);
    }

    public static sealed interface Builder
    extends Vector.Builder
    permits LongVectorBuilder, FixedBuilder {
        public Builder appendLong(long var1);

        @Override
        public LongVector build();
    }
}

