/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.migrate.task.ReindexDataStreamEnrichedStatus;

public class GetMigrationReindexStatusAction
extends ActionType<Response> {
    public static final GetMigrationReindexStatusAction INSTANCE = new GetMigrationReindexStatusAction();
    public static final String NAME = "indices:admin/migration/reindex_status";

    public GetMigrationReindexStatusAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest {
        private final String index;

        public Request(String index) {
            this.index = index;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Objects.hashCode(this.index);
        }

        public boolean equals(Object other) {
            return other instanceof Request && this.index.equals(((Request)((Object)other)).index);
        }

        public Request nodeRequest(String thisNodeId, long thisTaskId) {
            Request copy = new Request(this.index);
            copy.setParentTask(thisNodeId, thisTaskId);
            return copy;
        }

        public String[] indices() {
            return new String[]{this.index};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final ReindexDataStreamEnrichedStatus enrichedStatus;

        public Response(ReindexDataStreamEnrichedStatus enrichedStatus) {
            this.enrichedStatus = Objects.requireNonNull(enrichedStatus, "status is required");
        }

        public Response(StreamInput in) throws IOException {
            this.enrichedStatus = (ReindexDataStreamEnrichedStatus)in.readOptionalWriteable(ReindexDataStreamEnrichedStatus::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.enrichedStatus);
        }

        public ReindexDataStreamEnrichedStatus getEnrichedStatus() {
            return this.enrichedStatus;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.enrichedStatus.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(this.enrichedStatus);
        }

        public boolean equals(Object other) {
            return other instanceof Response && this.enrichedStatus.equals(((Response)((Object)other)).enrichedStatus);
        }

        public String toString() {
            String toString = Strings.toString((ToXContent)this);
            return toString.isEmpty() ? "unavailable" : toString;
        }
    }
}

