/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.internal.common.Util;
import com.nvidia.cuvs.internal.panama.headers_h;
import com.nvidia.cuvs.internal.panama.headers_h_1;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.file.Path;

public class CuVSResourcesImpl
implements CuVSResources {
    private final Path tempDirectory;
    private final long resourceHandle;
    private final CuVSResources.ScopedAccess access;
    private final int deviceId;

    public CuVSResourcesImpl(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment resourcesMemorySegment = localArena.allocate(headers_h.cuvsResources_t);
            Util.checkCuVSError(headers_h.cuvsResourcesCreate(resourcesMemorySegment), "cuvsResourcesCreate");
            this.resourceHandle = resourcesMemorySegment.get(headers_h.cuvsResources_t, 0L);
            MemorySegment deviceIdPtr = localArena.allocate(headers_h_1.C_INT);
            Util.checkCuVSError(headers_h.cuvsDeviceIdGet(this.resourceHandle, deviceIdPtr), "cuvsDeviceIdGet");
            this.deviceId = deviceIdPtr.get(headers_h_1.C_INT, 0L);
            this.access = new CuVSResources.ScopedAccess(){

                @Override
                public long handle() {
                    return CuVSResourcesImpl.this.resourceHandle;
                }

                @Override
                public void close() {
                }
            };
        }
    }

    @Override
    public CuVSResources.ScopedAccess access() {
        return this.access;
    }

    @Override
    public int deviceId() {
        return this.deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CuVSResourcesImpl cuVSResourcesImpl = this;
        synchronized (cuVSResourcesImpl) {
            int returnValue = headers_h.cuvsResourcesDestroy(this.resourceHandle);
            Util.checkCuVSError(returnValue, "cuvsResourcesDestroy");
        }
    }

    @Override
    public Path tempDirectory() {
        return this.tempDirectory;
    }
}

