/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.planner;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.eql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.eql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.eql.plan.physical.UnplannedExec;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.tree.Node;

abstract class Verifier {
    Verifier() {
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Failure.fail((Node)p, (String)"Unplanned item {}", (Object[])new Object[]{((UnplannedExec)p).plan().nodeName()}));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        return failures;
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Failure.fail((Node)p, (String)"Unexecutable item {}", (Object[])new Object[]{p.nodeName()}));
            }
            p.forEachExpressionUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        return failures;
    }
}

