/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.eql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.ql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.ql.querydsl.container.ScriptSort;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;

public abstract class SourceGenerator {
    private SourceGenerator() {
    }

    public static SearchSourceBuilder sourceBuilder(QueryContainer container, QueryBuilder filter, List<FieldAndFormat> fetchFields, Map<String, Object> runtimeMappings) {
        Object finalQuery = null;
        if (container.query() != null) {
            finalQuery = filter != null ? QueryBuilders.boolQuery().must(container.query().asBuilder()).filter(filter) : container.query().asBuilder();
        } else if (filter != null) {
            finalQuery = QueryBuilders.boolQuery().filter(filter);
        }
        SearchSourceBuilder source = new SearchSourceBuilder();
        source.query(finalQuery);
        QlSourceBuilder sourceBuilder = new QlSourceBuilder();
        container.fields().forEach(f -> ((FieldExtraction)f.v1()).collectFields(sourceBuilder));
        sourceBuilder.build(source);
        SourceGenerator.sorting(container, source);
        source.fetchSource(false);
        if (fetchFields != null) {
            fetchFields.forEach(arg_0 -> ((SearchSourceBuilder)source).fetchField(arg_0));
        }
        if (runtimeMappings != null) {
            source.runtimeMappings(runtimeMappings);
        }
        if (container.limit() != null) {
            source.size(container.limit().absLimit());
            if (container.limit().offset() > 0) {
                source.from(container.limit().offset());
            }
        } else {
            source.size(0);
        }
        SourceGenerator.optimize(container, source);
        return source;
    }

    private static void sorting(QueryContainer container, SearchSourceBuilder source) {
        for (Sort sortable : container.sort().values()) {
            ScriptSortBuilder sortBuilder = null;
            if (sortable instanceof AttributeSort) {
                AttributeSort as = (AttributeSort)sortable;
                Attribute attr = as.attribute();
                if (attr instanceof FieldAttribute) {
                    FieldAttribute fieldAttribute = (FieldAttribute)attr;
                    FieldAttribute fa = fieldAttribute.exactAttribute();
                    sortBuilder = SortBuilders.fieldSort((String)fa.name()).missing((Object)as.missing().searchOrder(as.direction())).unmappedType(fa.dataType().esType());
                    if (fa.isNested()) {
                        FieldSortBuilder fieldSort = SortBuilders.fieldSort((String)fa.name()).missing((Object)as.missing().searchOrder(as.direction())).unmappedType(fa.dataType().esType());
                        NestedSortBuilder newSort = new NestedSortBuilder(fa.nestedParent().name());
                        NestedSortBuilder nestedSort = fieldSort.getNestedSort();
                        if (nestedSort == null) {
                            fieldSort.setNestedSort(newSort);
                        } else {
                            while (nestedSort.getNestedSort() != null) {
                                nestedSort = nestedSort.getNestedSort();
                            }
                            nestedSort.setNestedSort(newSort);
                        }
                        nestedSort = newSort;
                        if (container.query() != null) {
                            container.query().enrichNestedSort(nestedSort);
                        }
                        sortBuilder = fieldSort;
                    }
                }
            } else if (sortable instanceof ScriptSort) {
                ScriptSort ss = (ScriptSort)sortable;
                sortBuilder = SortBuilders.scriptSort((Script)ss.script().toPainless(), (ScriptSortBuilder.ScriptSortType)ss.script().outputType().scriptSortType());
            }
            if (sortBuilder == null) continue;
            sortBuilder.order(sortable.direction().asOrder());
            source.sort(sortBuilder);
        }
    }

    private static void optimize(QueryContainer query, SearchSourceBuilder builder) {
        builder.trackTotalHits(query.shouldTrackHits());
    }
}

