/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.elasticsearch.analysis.common.ESSolrSynonymParser;
import org.elasticsearch.analysis.common.ESWordnetSynonymParser;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;

public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final String format;
    private final boolean expand;
    private final boolean lenient;
    protected final Settings settings;
    protected final Environment environment;
    protected final AnalysisMode analysisMode;
    private final SynonymsManagementAPIService synonymsManagementAPIService;
    protected final SynonymsSource synonymsSource;

    SynonymTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings, SynonymsManagementAPIService synonymsManagementAPIService) {
        super(name);
        this.settings = settings;
        this.synonymsSource = SynonymsSource.fromSettings(settings);
        this.expand = settings.getAsBoolean("expand", Boolean.valueOf(true));
        this.format = settings.get("format", "");
        boolean updateable = settings.getAsBoolean("updateable", Boolean.valueOf(false));
        this.lenient = settings.getAsBoolean("lenient", Boolean.valueOf(indexSettings.getIndexVersionCreated().onOrAfter((VersionId)IndexVersions.LENIENT_UPDATEABLE_SYNONYMS) && updateable));
        this.analysisMode = updateable ? AnalysisMode.SEARCH_TIME : AnalysisMode.ALL;
        this.environment = env;
        this.synonymsManagementAPIService = synonymsManagementAPIService;
    }

    public AnalysisMode getAnalysisMode() {
        return this.analysisMode;
    }

    public TokenStream create(TokenStream tokenStream) {
        throw new IllegalStateException("Call createPerAnalyzerSynonymFactory to specialize this factory for an analysis chain first");
    }

    public TokenFilterFactory getChainAwareTokenFilterFactory(IndexService.IndexCreationContext context, TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> previousTokenFilters, Function<String, TokenFilterFactory> allFilters) {
        Analyzer analyzer = SynonymTokenFilterFactory.buildSynonymAnalyzer(tokenizer, charFilters, previousTokenFilters);
        final ReaderWithOrigin rulesReader = this.synonymsSource.getRulesReader(this, context);
        final SynonymMap synonyms = this.buildSynonyms(analyzer, rulesReader);
        final String name = this.name();
        return new TokenFilterFactory(){

            public String name() {
                return name;
            }

            public TokenStream create(TokenStream tokenStream) {
                return synonyms.fst == null ? tokenStream : new SynonymFilter(tokenStream, synonyms, false);
            }

            public TokenFilterFactory getSynonymFilter() {
                return IDENTITY_FILTER;
            }

            public AnalysisMode getAnalysisMode() {
                return SynonymTokenFilterFactory.this.analysisMode;
            }

            public String getResourceName() {
                return rulesReader.resource();
            }
        };
    }

    static Analyzer buildSynonymAnalyzer(TokenizerFactory tokenizer, List<CharFilterFactory> charFilters, List<TokenFilterFactory> tokenFilters) {
        return new CustomAnalyzer(tokenizer, charFilters.toArray(new CharFilterFactory[0]), (TokenFilterFactory[])tokenFilters.stream().map(TokenFilterFactory::getSynonymFilter).toArray(TokenFilterFactory[]::new));
    }

    SynonymMap buildSynonyms(Analyzer analyzer, ReaderWithOrigin rules) {
        try {
            Object parser;
            if ("wordnet".equalsIgnoreCase(this.format)) {
                parser = new ESWordnetSynonymParser(true, this.expand, this.lenient, analyzer);
                parser.parse(rules.reader);
            } else {
                parser = new ESSolrSynonymParser(true, this.expand, this.lenient, analyzer);
                ((ESSolrSynonymParser)((Object)parser)).parse(rules.reader);
            }
            return parser.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to build synonyms from [" + rules.origin + "]", e);
        }
    }

    protected static enum SynonymsSource {
        INLINE("synonyms"){

            @Override
            public ReaderWithOrigin getRulesReader(SynonymTokenFilterFactory factory, IndexService.IndexCreationContext context) {
                List rulesList = Analysis.getWordList((Environment)factory.environment, (Settings)factory.settings, (String)INLINE.getSettingName());
                StringBuilder sb = new StringBuilder();
                for (String line : rulesList) {
                    sb.append(line).append(System.lineSeparator());
                }
                return new ReaderWithOrigin(new StringReader(sb.toString()), "'" + factory.name() + "' analyzer settings");
            }
        }
        ,
        INDEX("synonyms_set"){

            @Override
            public ReaderWithOrigin getRulesReader(SynonymTokenFilterFactory factory, IndexService.IndexCreationContext context) {
                if (factory.analysisMode != AnalysisMode.SEARCH_TIME) {
                    throw new IllegalArgumentException("Can't apply [" + INDEX.getSettingName() + "]! Loading synonyms from index is supported only for search time synonyms!");
                }
                String synonymsSet = factory.settings.get(INDEX.getSettingName(), null);
                ReaderWithOrigin reader = context != IndexService.IndexCreationContext.RELOAD_ANALYZERS ? new ReaderWithOrigin(new StringReader(""), "fake empty [" + synonymsSet + "] synonyms_set in .synonyms index", synonymsSet) : new ReaderWithOrigin(Analysis.getReaderFromIndex((String)synonymsSet, (SynonymsManagementAPIService)factory.synonymsManagementAPIService, (boolean)factory.lenient), "[" + synonymsSet + "] synonyms_set in .synonyms index", synonymsSet);
                return reader;
            }
        }
        ,
        LOCAL_FILE("synonyms_path"){

            @Override
            public ReaderWithOrigin getRulesReader(SynonymTokenFilterFactory factory, IndexService.IndexCreationContext context) {
                String synonymsPath = factory.settings.get(LOCAL_FILE.getSettingName(), null);
                return new ReaderWithOrigin(Analysis.getReaderFromFile((Environment)factory.environment, (String)synonymsPath, (String)INLINE.getSettingName()), synonymsPath);
            }
        };

        private final String settingName;

        private SynonymsSource(String settingName) {
            this.settingName = settingName;
        }

        public abstract ReaderWithOrigin getRulesReader(SynonymTokenFilterFactory var1, IndexService.IndexCreationContext var2);

        public String getSettingName() {
            return this.settingName;
        }

        public static SynonymsSource fromSettings(Settings settings) {
            SynonymsSource synonymsSource;
            if (settings.hasValue(INLINE.getSettingName())) {
                synonymsSource = INLINE;
            } else if (settings.hasValue(INDEX.getSettingName())) {
                synonymsSource = INDEX;
            } else if (settings.hasValue(LOCAL_FILE.getSettingName())) {
                synonymsSource = LOCAL_FILE;
            } else {
                throw new IllegalArgumentException("synonym requires either `" + INLINE.getSettingName() + "`, `" + INDEX.getSettingName() + "` or `" + LOCAL_FILE.getSettingName() + "` to be configured");
            }
            return synonymsSource;
        }
    }

    record ReaderWithOrigin(Reader reader, String origin, String resource) {
        ReaderWithOrigin(Reader reader, String origin) {
            this(reader, origin, null);
        }
    }
}

