/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.utils;

import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.rest.RestStatus;

public class ExceptionCollectionHandling {
    public static ElasticsearchStatusException exceptionArrayToStatusException(AtomicArray<Exception> failures, String message) {
        List caughtExceptions = failures.asList();
        if (caughtExceptions.isEmpty()) {
            assert (false) : "method to combine exceptions called with no exceptions";
            return new ElasticsearchStatusException("No exceptions caught", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        boolean allElasticsearchException = true;
        boolean allStatus4xx = true;
        for (Exception exception : caughtExceptions) {
            if (exception instanceof ElasticsearchException) {
                ElasticsearchException elasticsearchException = (ElasticsearchException)((Object)exception);
                if (elasticsearchException.status().getStatus() >= 400 && elasticsearchException.status().getStatus() < 500) continue;
                allStatus4xx = false;
                continue;
            }
            allElasticsearchException = false;
            break;
        }
        if (allElasticsearchException && allStatus4xx) {
            return new ElasticsearchStatusException(message, ((ElasticsearchException)((Object)caughtExceptions.get(0))).status(), (Throwable)caughtExceptions.get(0), new Object[0]);
        }
        return new ElasticsearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
    }
}

