/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;

public class WritableIndexExpander {
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private static WritableIndexExpander INSTANCE;

    public static void initialize(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        INSTANCE = new WritableIndexExpander(clusterService, indexNameExpressionResolver);
    }

    public static void initialize(WritableIndexExpander newInstance) {
        INSTANCE = newInstance;
    }

    public static WritableIndexExpander getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("WritableIndexExpander is not initialized");
        }
        return INSTANCE;
    }

    protected WritableIndexExpander(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = Objects.requireNonNull(clusterService);
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
    }

    public ArrayList<String> getWritableIndices(String indexPattern) {
        return this.getWritableIndices(List.of(indexPattern));
    }

    public ArrayList<String> getWritableIndices(Collection<String> indices) {
        if (indices == null || indices.isEmpty()) {
            return new ArrayList<String>();
        }
        ClusterState clusterState = this.clusterService.state();
        return indices.stream().map(index -> this.indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.LENIENT_EXPAND_OPEN_HIDDEN, new String[]{index})).flatMap(Arrays::stream).filter(index -> this.isIndexReadOnly((String)index) == false).collect(Collectors.toCollection(ArrayList::new));
    }

    private Boolean isIndexReadOnly(String indexName) {
        IndexMetadata indexMetadata = this.clusterService.state().metadata().getProject().index(indexName);
        if (indexMetadata == null) {
            throw new IllegalArgumentException("Failed to identify if index is read-only: index [" + indexName + "] not found");
        }
        if (indexMetadata.getSettings() == null) {
            throw new IllegalStateException("Settings for index [" + indexName + "] are unavailable");
        }
        return (Boolean)IndexMetadata.INDEX_BLOCKS_WRITE_SETTING.get(indexMetadata.getSettings());
    }
}

