/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.action.TransformTaskMatcher;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;

public class UpdateTransformAction
extends ActionType<Response> {
    public static final UpdateTransformAction INSTANCE = new UpdateTransformAction();
    public static final String NAME = "cluster:admin/transform/update";
    private static final TimeValue MIN_FREQUENCY = TimeValue.timeValueSeconds((long)1L);
    private static final TimeValue MAX_FREQUENCY = TimeValue.timeValueHours((long)1L);

    private UpdateTransformAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private final TransformConfig config;

        public Response(TransformConfig config) {
            super(Collections.emptyList(), Collections.emptyList());
            this.config = config;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.config = new TransformConfig(in);
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.config);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.config, other.config) && super.equals(obj);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.toXContentCommon(builder, params);
            return this.config.toXContent(builder, params);
        }
    }

    public static final class Request
    extends BaseTasksRequest<Request> {
        private final TransformConfigUpdate update;
        private final String id;
        private final boolean deferValidation;
        private TransformConfig config;
        private AuthorizationState authState;

        public Request(TransformConfigUpdate update, String id, boolean deferValidation, TimeValue timeout) {
            this.update = update;
            this.id = id;
            this.deferValidation = deferValidation;
            this.setTimeout(timeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.update = new TransformConfigUpdate(in);
            this.id = in.readString();
            this.deferValidation = in.readBoolean();
            if (in.readBoolean()) {
                this.config = new TransformConfig(in);
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0) && in.readBoolean()) {
                this.authState = new AuthorizationState(in);
            }
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation, TimeValue timeout) {
            return new Request(TransformConfigUpdate.fromXContent(parser), id, deferValidation, timeout);
        }

        public ActionRequestValidationException validate() {
            TimeValue frequency;
            ActionRequestValidationException validationException = null;
            if (this.update.getDestination() != null && this.update.getDestination().getIndex() != null) {
                validationException = SourceDestValidator.validateRequest(validationException, this.update.getDestination().getIndex());
            }
            if ((frequency = this.update.getFrequency()) != null) {
                if (frequency.compareTo(MIN_FREQUENCY) < 0) {
                    validationException = ValidateActions.addValidationError((String)("minimum permitted [" + String.valueOf(TransformField.FREQUENCY) + "] is [" + MIN_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                } else if (frequency.compareTo(MAX_FREQUENCY) > 0) {
                    validationException = ValidateActions.addValidationError((String)("highest permitted [" + String.valueOf(TransformField.FREQUENCY) + "] is [" + MAX_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public TransformConfigUpdate getUpdate() {
            return this.update;
        }

        public TransformConfig getConfig() {
            return this.config;
        }

        public void setConfig(TransformConfig config) {
            this.config = config;
        }

        public AuthorizationState getAuthState() {
            return this.authState;
        }

        public void setAuthState(AuthorizationState authState) {
            this.authState = authState;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.update.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.deferValidation);
            if (this.config == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.config.writeTo(out);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
                if (this.authState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    this.authState.writeTo(out);
                }
            }
        }

        public int hashCode() {
            return Objects.hash(this.getTimeout(), this.update, this.id, this.deferValidation, this.config, this.authState);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.update, other.update) && this.deferValidation == other.deferValidation && this.id.equals(other.id) && Objects.equals(this.config, other.config) && Objects.equals(this.authState, other.authState) && this.getTimeout().equals((Object)other.getTimeout());
        }

        public boolean match(Task task) {
            TransformTaskMatcher matcher;
            return task instanceof TransformTaskMatcher && (matcher = (TransformTaskMatcher)task).match(this.id);
        }
    }
}

