/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.CustomAuthenticator;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.service.ServiceAccountTokenStore;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;

public interface SecurityExtension {
    default public Map<String, Realm.Factory> getRealms(SecurityComponents components) {
        return Collections.emptyMap();
    }

    default public AuthenticationFailureHandler getAuthenticationFailureHandler(SecurityComponents components) {
        return null;
    }

    default public List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> getRolesProviders(SecurityComponents components) {
        return Collections.emptyList();
    }

    default public ServiceAccountTokenStore getServiceAccountTokenStore(SecurityComponents components) {
        return null;
    }

    default public List<CustomAuthenticator> getCustomAuthenticators(SecurityComponents components) {
        return null;
    }

    default public AuthorizationEngine getAuthorizationEngine(Settings settings) {
        return null;
    }

    default public String extensionName() {
        return this.getClass().getName();
    }

    public static interface SecurityComponents {
        public Settings settings();

        public Environment environment();

        public Client client();

        public ThreadPool threadPool();

        public ResourceWatcherService resourceWatcherService();

        public ClusterService clusterService();

        public UserRoleMapper roleMapper();

        public ProjectResolver projectResolver();
    }
}

