/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.InferenceContext;

public abstract class BaseInferenceActionRequest
extends LegacyActionRequest {
    private static final TransportVersion INFERENCE_CONTEXT = TransportVersion.fromName((String)"inference_context");
    static final TransportVersion INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING_REMOVED = TransportVersion.fromName((String)"inference_request_adaptive_rate_limiting_removed");
    private final InferenceContext context;

    public BaseInferenceActionRequest(InferenceContext context) {
        this.context = context;
    }

    public BaseInferenceActionRequest(StreamInput in) throws IOException {
        super(in);
        if (!in.getTransportVersion().supports(INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING_REMOVED)) {
            in.readBoolean();
        }
        this.context = in.getTransportVersion().supports(INFERENCE_CONTEXT) ? new InferenceContext(in) : InferenceContext.EMPTY_INSTANCE;
    }

    public abstract boolean isStreaming();

    public abstract TaskType getTaskType();

    public abstract String getInferenceEntityId();

    public InferenceContext getContext() {
        return this.context;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!out.getTransportVersion().supports(INFERENCE_REQUEST_ADAPTIVE_RATE_LIMITING_REMOVED)) {
            out.writeBoolean(true);
        }
        if (out.getTransportVersion().supports(INFERENCE_CONTEXT)) {
            this.context.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BaseInferenceActionRequest that = (BaseInferenceActionRequest)((Object)o);
        return Objects.equals(this.context, that.context);
    }

    public int hashCode() {
        return Objects.hash(this.context);
    }
}

