/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.internal.MutableLicenseService;
import org.elasticsearch.protocol.xpack.license.PutLicenseResponse;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutLicenseAction
extends TransportMasterNodeAction<PutLicenseRequest, PutLicenseResponse> {
    private final MutableLicenseService licenseService;

    @Inject
    public TransportPutLicenseAction(TransportService transportService, ClusterService clusterService, MutableLicenseService licenseService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/xpack/license/put", transportService, clusterService, threadPool, actionFilters, PutLicenseRequest::new, PutLicenseResponse::new, (Executor)threadPool.executor("management"));
        this.licenseService = licenseService;
    }

    protected ClusterBlockException checkBlock(PutLicenseRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, PutLicenseRequest request, ClusterState state, ActionListener<PutLicenseResponse> listener) throws ElasticsearchException {
        this.licenseService.registerLicense(request, listener);
    }
}

