/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.http.HttpResponseInterceptor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.lucene.util.IORunnable;
import org.apache.lucene.util.IOSupplier;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.common.blobstore.BlobStoreActionStats;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.TimeProvider;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.gcs.OperationStats;
import org.elasticsearch.repositories.gcs.StorageOperation;

public class GcsRepositoryStatsCollector {
    static final TimeProvider NOOP_TIMER = new TimeProvider(){

        public long relativeTimeInMillis() {
            return 0L;
        }

        public long relativeTimeInNanos() {
            return 0L;
        }

        public long rawRelativeTimeInMillis() {
            return 0L;
        }

        public long absoluteTimeInMillis() {
            return 0L;
        }
    };
    private static final ThreadLocal<OperationStats> OPERATION_STATS = new ThreadLocal();
    public static final HttpResponseInterceptor METERING_INTERCEPTOR = response -> {
        OperationStats stats = GcsRepositoryStatsCollector.getThreadLocal();
        int code = response.getStatusCode();
        ++stats.requestAttempts;
        stats.isLastRequestSucceed = true;
        if (!(code >= 200 && code < 300 || code == 308 || code == 404)) {
            ++stats.requestError;
            stats.isLastRequestSucceed = false;
            switch (code) {
                case 416: {
                    ++stats.requestRangeError;
                    break;
                }
                case 429: {
                    ++stats.requestThrottle;
                }
            }
        }
    };
    private final EnumMap<OperationPurpose, EnumMap<StorageOperation, Collector>> collectors;
    private final RepositoriesMetrics telemetry;
    private final EnumMap<OperationPurpose, EnumMap<StorageOperation, Map<String, Object>>> telemetryAttributes;
    private final TimeProvider timer;

    GcsRepositoryStatsCollector() {
        this(NOOP_TIMER, new RepositoryMetadata("gcs", "", Settings.EMPTY), RepositoriesMetrics.NOOP);
    }

    GcsRepositoryStatsCollector(TimeProvider timer, RepositoryMetadata metadata, RepositoriesMetrics repositoriesMetrics) {
        this.timer = timer;
        this.telemetry = repositoriesMetrics;
        this.collectors = new EnumMap(OperationPurpose.class);
        for (OperationPurpose purpose : OperationPurpose.values()) {
            EnumMap<StorageOperation, Collector> operationsMap = new EnumMap<StorageOperation, Collector>(StorageOperation.class);
            for (StorageOperation op : StorageOperation.values()) {
                operationsMap.put(op, new Collector(new LongAdder(), new LongAdder()));
            }
            this.collectors.put(purpose, operationsMap);
        }
        this.telemetryAttributes = new EnumMap(OperationPurpose.class);
        for (OperationPurpose purpose : OperationPurpose.values()) {
            EnumMap<StorageOperation, Map> purposeMap = new EnumMap<StorageOperation, Map>(StorageOperation.class);
            this.telemetryAttributes.put(purpose, purposeMap);
            for (StorageOperation operation : StorageOperation.values()) {
                Map attrMap = RepositoriesMetrics.createAttributesMap((RepositoryMetadata)metadata, (OperationPurpose)purpose, (String)operation.key);
                purposeMap.put(operation, attrMap);
            }
        }
    }

    private static OperationStats initAndGetThreadLocal(OperationPurpose purpose, StorageOperation operation) {
        assert (OPERATION_STATS.get() == null) : "cannot init stats, thread local is not empty";
        OperationStats stats = new OperationStats(purpose, operation);
        OPERATION_STATS.set(stats);
        return stats;
    }

    static OperationStats getThreadLocal() {
        OperationStats stats = OPERATION_STATS.get();
        assert (stats != null) : "must initialize operation stats";
        return stats;
    }

    private static void setThreadLocal(OperationStats stats) {
        assert (OPERATION_STATS.get() == null) : "cannot set stats, thread local is not empty";
        OPERATION_STATS.set(stats);
    }

    private static void clearThreadLocal() {
        assert (OPERATION_STATS.get() != null) : "cannot clear already emptied thread local";
        OPERATION_STATS.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T continueWithStats(OperationStats stats, IOSupplier<T> blobFn) throws IOException {
        GcsRepositoryStatsCollector.setThreadLocal(stats);
        long t = this.timer.absoluteTimeInMillis();
        try {
            Object object = blobFn.get();
            return (T)object;
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRunnable(OperationStats stats, IORunnable runnable) throws IOException {
        GcsRepositoryStatsCollector.setThreadLocal(stats);
        long t = this.timer.absoluteTimeInMillis();
        try {
            runnable.run();
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            this.collect(stats);
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectIORunnable(OperationPurpose purpose, StorageOperation operation, IORunnable runnable) throws IOException {
        OperationStats stats = GcsRepositoryStatsCollector.initAndGetThreadLocal(purpose, operation);
        long t = this.timer.absoluteTimeInMillis();
        try {
            runnable.run();
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRunnable(OperationPurpose purpose, StorageOperation operation, Runnable runnable) {
        long t = this.timer.absoluteTimeInMillis();
        OperationStats stats = GcsRepositoryStatsCollector.initAndGetThreadLocal(purpose, operation);
        try {
            runnable.run();
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            this.collect(stats);
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T collectIOSupplier(OperationPurpose purpose, StorageOperation operation, IOSupplier<T> blobFn) throws IOException {
        long t = this.timer.absoluteTimeInMillis();
        OperationStats stats = GcsRepositoryStatsCollector.initAndGetThreadLocal(purpose, operation);
        try {
            Object object = blobFn.get();
            return (T)object;
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            this.collect(stats);
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T collectSupplier(OperationPurpose purpose, StorageOperation operation, Supplier<T> blobFn) {
        long t = this.timer.absoluteTimeInMillis();
        OperationStats stats = GcsRepositoryStatsCollector.initAndGetThreadLocal(purpose, operation);
        try {
            T t2 = blobFn.get();
            return t2;
        }
        finally {
            stats.totalDuration += this.timer.absoluteTimeInMillis() - t;
            this.collect(stats);
            GcsRepositoryStatsCollector.clearThreadLocal();
        }
    }

    private void collect(OperationStats stats) {
        if (stats.requestAttempts == 0) {
            return;
        }
        OperationPurpose purpose = stats.purpose;
        StorageOperation operation = stats.operation;
        int operationSuccess = stats.isLastRequestSucceed ? 1 : 0;
        int operationError = stats.isLastRequestSucceed ? 0 : 1;
        Collector collector = this.collectors.get(purpose).get((Object)operation);
        assert (collector != null);
        collector.operations.add(operationSuccess);
        collector.requests.add(stats.requestAttempts);
        Map<String, Object> attr = this.telemetryAttributes.get(purpose).get((Object)operation);
        assert (attr != null);
        this.telemetry.operationCounter().incrementBy((long)operationSuccess, attr);
        this.telemetry.unsuccessfulOperationCounter().incrementBy((long)operationError, attr);
        this.telemetry.requestCounter().incrementBy((long)stats.requestAttempts, attr);
        this.telemetry.exceptionCounter().incrementBy((long)stats.requestError, attr);
        this.telemetry.exceptionHistogram().record((long)stats.requestError, attr);
        this.telemetry.throttleCounter().incrementBy((long)stats.requestThrottle, attr);
        this.telemetry.throttleHistogram().record((long)stats.requestThrottle, attr);
        this.telemetry.requestRangeNotSatisfiedExceptionCounter().incrementBy((long)stats.requestRangeError, attr);
        this.telemetry.httpRequestTimeInMillisHistogram().record(stats.totalDuration, attr);
    }

    public Map<String, BlobStoreActionStats> operationsStats(boolean isServerless) {
        HashMap<String, BlobStoreActionStats> out = new HashMap<String, BlobStoreActionStats>();
        for (Map.Entry<OperationPurpose, EnumMap<StorageOperation, Collector>> purposeCollector : this.collectors.entrySet()) {
            for (Map.Entry<StorageOperation, Collector> operationCollector : this.collectors.get(purposeCollector.getKey()).entrySet()) {
                Collector collector = operationCollector.getValue();
                long operations = collector.operations.sum();
                long requests = collector.requests.sum();
                if (isServerless) {
                    out.put(purposeCollector.getKey().getKey() + "_" + operationCollector.getKey().key(), new BlobStoreActionStats(operations, requests));
                    continue;
                }
                out.compute(operationCollector.getKey().key(), (k, v) -> {
                    if (v == null) {
                        return new BlobStoreActionStats(operations, requests);
                    }
                    return v.add(new BlobStoreActionStats(operations, requests));
                });
            }
        }
        return out;
    }

    record Collector(LongAdder operations, LongAdder requests) {
    }
}

