/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OperationPurposeRequestControl
extends Control {
    @NotNull
    public static final String OPERATION_PURPOSE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.19";
    private static final byte TYPE_APP_NAME = -128;
    private static final byte TYPE_APP_VERSION = -127;
    private static final byte TYPE_CODE_LOCATION = -126;
    private static final byte TYPE_REQUEST_PURPOSE = -125;
    @NotNull
    private static final String JSON_FIELD_APPLICATION_NAME = "application-name";
    @NotNull
    private static final String JSON_FIELD_APPLICATION_VERSION = "application-version";
    @NotNull
    private static final String JSON_FIELD_CODE_LOCATION = "code-location";
    @NotNull
    private static final String JSON_FIELD_REQUEST_PURPOSE = "request-purpose";
    private static final long serialVersionUID = -5552051862785419833L;
    @Nullable
    private final String applicationName;
    @Nullable
    private final String applicationVersion;
    @Nullable
    private final String codeLocation;
    @Nullable
    private final String requestPurpose;

    public OperationPurposeRequestControl(@Nullable String applicationName, @Nullable String applicationVersion, int codeLocationFrames, @Nullable String requestPurpose) {
        this(false, applicationName, applicationVersion, OperationPurposeRequestControl.generateStackTrace(codeLocationFrames), requestPurpose);
    }

    public OperationPurposeRequestControl(boolean isCritical, @Nullable String applicationName, @Nullable String applicationVersion, @Nullable String codeLocation, @Nullable String requestPurpose) {
        super(OPERATION_PURPOSE_REQUEST_OID, isCritical, OperationPurposeRequestControl.encodeValue(applicationName, applicationVersion, codeLocation, requestPurpose));
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.codeLocation = codeLocation;
        this.requestPurpose = requestPurpose;
    }

    public OperationPurposeRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Element[] valueElements;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_NO_VALUE.get());
        }
        try {
            valueElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (valueElements.length == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_SEQUENCE_EMPTY.get());
        }
        String appName = null;
        String appVersion = null;
        String codeLoc = null;
        String reqPurpose = null;
        block8: for (ASN1Element e : valueElements) {
            switch (e.getType()) {
                case -128: {
                    appName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -127: {
                    appVersion = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -126: {
                    codeLoc = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -125: {
                    reqPurpose = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_UNSUPPORTED_ELEMENT.get(StaticUtils.toHex(e.getType())));
                }
            }
        }
        this.applicationName = appName;
        this.applicationVersion = appVersion;
        this.codeLocation = codeLoc;
        this.requestPurpose = reqPurpose;
    }

    @NotNull
    private static String generateStackTrace(int numFrames) {
        StringBuilder buffer = new StringBuilder();
        int n = numFrames > 0 ? numFrames : Integer.MAX_VALUE;
        int c = 0;
        boolean skip = true;
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            int lastPeriodPos;
            String className = e.getClassName();
            if (className.equals(OperationPurposeRequestControl.class.getName())) {
                skip = false;
                continue;
            }
            if (skip) continue;
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            if ((lastPeriodPos = className.lastIndexOf(46)) > 0) {
                buffer.append(className.substring(lastPeriodPos + 1));
            } else {
                buffer.append(className);
            }
            buffer.append('.');
            buffer.append(e.getMethodName());
            buffer.append(':');
            buffer.append(e.getLineNumber());
            if (++c >= n) break;
        }
        return buffer.toString();
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String applicationName, @Nullable String applicationVersion, @Nullable String codeLocation, @Nullable String requestPurpose) {
        Validator.ensureFalse(applicationName == null && applicationVersion == null && codeLocation == null && requestPurpose == null);
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(4);
        if (applicationName != null) {
            elements.add(new ASN1OctetString(-128, applicationName));
        }
        if (applicationVersion != null) {
            elements.add(new ASN1OctetString(-127, applicationVersion));
        }
        if (codeLocation != null) {
            elements.add(new ASN1OctetString(-126, codeLocation));
        }
        if (requestPurpose != null) {
            elements.add(new ASN1OctetString(-125, requestPurpose));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    @Nullable
    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    @Nullable
    public String getCodeLocation() {
        return this.codeLocation;
    }

    @Nullable
    public String getRequestPurpose() {
        return this.requestPurpose;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_OP_PURPOSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (this.applicationName != null) {
            valueFields.put(JSON_FIELD_APPLICATION_NAME, new JSONString(this.applicationName));
        }
        if (this.applicationVersion != null) {
            valueFields.put(JSON_FIELD_APPLICATION_VERSION, new JSONString(this.applicationVersion));
        }
        if (this.codeLocation != null) {
            valueFields.put(JSON_FIELD_CODE_LOCATION, new JSONString(this.codeLocation));
        }
        if (this.requestPurpose != null) {
            valueFields.put(JSON_FIELD_REQUEST_PURPOSE, new JSONString(this.requestPurpose));
        }
        return new JSONObject(new JSONField("oid", OPERATION_PURPOSE_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_OP_PURPOSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static OperationPurposeRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new OperationPurposeRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        String applicationName = valueObject.getFieldAsString(JSON_FIELD_APPLICATION_NAME);
        String applicationVersion = valueObject.getFieldAsString(JSON_FIELD_APPLICATION_VERSION);
        String codeLocation = valueObject.getFieldAsString(JSON_FIELD_CODE_LOCATION);
        String requestPurpose = valueObject.getFieldAsString(JSON_FIELD_REQUEST_PURPOSE);
        if (applicationName == null && applicationVersion == null && codeLocation == null && requestPurpose == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_APPLICATION_NAME, JSON_FIELD_APPLICATION_VERSION, JSON_FIELD_CODE_LOCATION, JSON_FIELD_REQUEST_PURPOSE));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_APPLICATION_NAME, JSON_FIELD_APPLICATION_VERSION, JSON_FIELD_CODE_LOCATION, JSON_FIELD_REQUEST_PURPOSE)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new OperationPurposeRequestControl(jsonControl.getCriticality(), applicationName, applicationVersion, codeLocation, requestPurpose);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("OperationPurposeRequestControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.applicationName != null) {
            buffer.append(", appName='");
            buffer.append(this.applicationName);
            buffer.append('\'');
        }
        if (this.applicationVersion != null) {
            buffer.append(", appVersion='");
            buffer.append(this.applicationVersion);
            buffer.append('\'');
        }
        if (this.codeLocation != null) {
            buffer.append(", codeLocation='");
            buffer.append(this.codeLocation);
            buffer.append('\'');
        }
        if (this.requestPurpose != null) {
            buffer.append(", purpose='");
            buffer.append(this.requestPurpose);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

