/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ActiveAlertsLDAPConnectionPoolHealthCheck
extends LDAPConnectionPoolHealthCheck
implements Serializable {
    private static final long DEFAULT_MAX_RESPONSE_TIME_MILLIS = 5000L;
    @NotNull
    private static final String DEGRADED_ALERT_TYPE_ATTRIBUTE_NAME = "degraded-alert-type";
    @NotNull
    private static final String GENERAL_MONITOR_ENTRY_DN = "cn=monitor";
    @NotNull
    private static final String UNAVAILABLE_ALERT_TYPE_ATTRIBUTE_NAME = "unavailable-alert-type";
    private static final long serialVersionUID = -8889308187890719816L;
    private final boolean ignoreAllDegradedAlertTypes;
    private final boolean invokeAfterAuthentication;
    private final boolean invokeForBackgroundChecks;
    private final boolean invokeOnCheckout;
    private final boolean invokeOnCreate;
    private final boolean invokeOnException;
    private final boolean invokeOnRelease;
    private final long maxResponseTimeMillis;
    @NotNull
    private final Map<String, String> ignoredDegradedAlertTypes;
    @NotNull
    private final Map<String, String> ignoredUnavailableAlertTypes;
    @NotNull
    private final SearchRequest searchRequest;

    public ActiveAlertsLDAPConnectionPoolHealthCheck(boolean invokeOnCreate, boolean invokeAfterAuthentication, boolean invokeOnCheckout, boolean invokeOnRelease, boolean invokeForBackgroundChecks, boolean invokeOnException, long maxResponseTimeMillis, boolean ignoreAllDegradedAlertTypes, @Nullable Collection<String> ignoredDegradedAlertTypes, @Nullable Collection<String> ignoredUnavailableAlertTypes) {
        this.invokeOnCreate = invokeOnCreate;
        this.invokeAfterAuthentication = invokeAfterAuthentication;
        this.invokeOnCheckout = invokeOnCheckout;
        this.invokeOnRelease = invokeOnRelease;
        this.invokeForBackgroundChecks = invokeForBackgroundChecks;
        this.invokeOnException = invokeOnException;
        this.ignoreAllDegradedAlertTypes = ignoreAllDegradedAlertTypes;
        this.ignoredDegradedAlertTypes = ActiveAlertsLDAPConnectionPoolHealthCheck.getIgnoredAlertTypes(ignoredDegradedAlertTypes);
        this.ignoredUnavailableAlertTypes = ActiveAlertsLDAPConnectionPoolHealthCheck.getIgnoredAlertTypes(ignoredUnavailableAlertTypes);
        this.maxResponseTimeMillis = maxResponseTimeMillis > 0L ? maxResponseTimeMillis : 5000L;
        int timeLimitSeconds = (int)(this.maxResponseTimeMillis / 1000L);
        if (this.maxResponseTimeMillis % 1000L != 0L) {
            ++timeLimitSeconds;
        }
        this.searchRequest = new SearchRequest(GENERAL_MONITOR_ENTRY_DN, SearchScope.BASE, DereferencePolicy.NEVER, 1, timeLimitSeconds, false, Filter.createANDFilter(new Filter[0]), DEGRADED_ALERT_TYPE_ATTRIBUTE_NAME, UNAVAILABLE_ALERT_TYPE_ATTRIBUTE_NAME);
        this.searchRequest.setResponseTimeoutMillis(this.maxResponseTimeMillis);
    }

    @NotNull
    private static Map<String, String> getIgnoredAlertTypes(@Nullable Collection<String> alertTypes) {
        if (alertTypes == null || alertTypes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> alertTypeMap = new LinkedHashMap<String, String>(StaticUtils.computeMapCapacity(alertTypes.size()));
        for (String alertType : alertTypes) {
            alertTypeMap.put(ActiveAlertsLDAPConnectionPoolHealthCheck.formatAlertTypeForComparison(alertType), alertType);
        }
        return Collections.unmodifiableMap(alertTypeMap);
    }

    @NotNull
    private static String formatAlertTypeForComparison(@NotNull String name) {
        return StaticUtils.toLowerCase(name).replace('_', '-');
    }

    @Override
    public void ensureNewConnectionValid(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCreate) {
            this.checkActiveAlertTypes(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterAuthentication(@NotNull LDAPConnection connection, @NotNull BindResult bindResult) throws LDAPException {
        if (this.invokeAfterAuthentication && bindResult.getResultCode() == ResultCode.SUCCESS) {
            this.checkActiveAlertTypes(connection);
        }
    }

    @Override
    public void ensureConnectionValidForCheckout(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnCheckout) {
            this.checkActiveAlertTypes(connection);
        }
    }

    @Override
    public void ensureConnectionValidForRelease(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeOnRelease) {
            this.checkActiveAlertTypes(connection);
        }
    }

    @Override
    public void ensureConnectionValidForContinuedUse(@NotNull LDAPConnection connection) throws LDAPException {
        if (this.invokeForBackgroundChecks) {
            this.checkActiveAlertTypes(connection);
        }
    }

    @Override
    public void ensureConnectionValidAfterException(@NotNull LDAPConnection connection, @NotNull LDAPException exception) throws LDAPException {
        if (this.invokeOnException && !ResultCode.isConnectionUsable(exception.getResultCode())) {
            this.checkActiveAlertTypes(connection);
        }
    }

    public boolean invokeOnCreate() {
        return this.invokeOnCreate;
    }

    public boolean invokeAfterAuthentication() {
        return this.invokeAfterAuthentication;
    }

    public boolean invokeOnCheckout() {
        return this.invokeOnCheckout;
    }

    public boolean invokeOnRelease() {
        return this.invokeOnRelease;
    }

    public boolean invokeForBackgroundChecks() {
        return this.invokeForBackgroundChecks;
    }

    public boolean invokeOnException() {
        return this.invokeOnException;
    }

    public long getMaxResponseTimeMillis() {
        return this.maxResponseTimeMillis;
    }

    public boolean ignoreAllDegradedAlertTypes() {
        return this.ignoreAllDegradedAlertTypes;
    }

    @NotNull
    public Collection<String> getIgnoredDegradedAlertTypes() {
        return this.ignoredDegradedAlertTypes.values();
    }

    @NotNull
    public Collection<String> getIgnoredUnavailableAlertTypes() {
        return this.ignoredUnavailableAlertTypes.values();
    }

    private void checkActiveAlertTypes(@NotNull LDAPConnection conn) throws LDAPException {
        String[] degradedAlertTypes;
        SearchResultEntry monitorEntry;
        try {
            monitorEntry = conn.searchForEntry(this.searchRequest.duplicate());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            String message = UnboundIDDSMessages.ERR_ACTIVE_ALERTS_HEALTH_CHECK_ERROR_GETTING_MONITOR_ENTRY.get(GENERAL_MONITOR_ENTRY_DN, conn.getHostPort(), StaticUtils.getExceptionMessage(e));
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, e);
            throw new LDAPException(e.getResultCode(), message, e);
        }
        if (monitorEntry == null) {
            String message = UnboundIDDSMessages.ERR_ACTIVE_ALERTS_HEALTH_CHECK_NO_MONITOR_ENTRY.get(GENERAL_MONITOR_ENTRY_DN, conn.getHostPort());
            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
            throw new LDAPException(ResultCode.NO_RESULTS_RETURNED, message);
        }
        String[] unavailableAlertTypes = monitorEntry.getAttributeValues(UNAVAILABLE_ALERT_TYPE_ATTRIBUTE_NAME);
        if (unavailableAlertTypes != null) {
            for (String alertType : unavailableAlertTypes) {
                if (this.ignoredUnavailableAlertTypes.containsKey(ActiveAlertsLDAPConnectionPoolHealthCheck.formatAlertTypeForComparison(alertType))) continue;
                String message = UnboundIDDSMessages.ERR_ACTIVE_ALERTS_HEALTH_CHECK_UNAVAILABLE_ALERT.get(GENERAL_MONITOR_ENTRY_DN, conn.getHostPort(), alertType);
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
                throw new LDAPException(ResultCode.UNAVAILABLE, message);
            }
        }
        if (!this.ignoreAllDegradedAlertTypes && (degradedAlertTypes = monitorEntry.getAttributeValues(DEGRADED_ALERT_TYPE_ATTRIBUTE_NAME)) != null) {
            for (String alertType : degradedAlertTypes) {
                if (this.ignoredDegradedAlertTypes.containsKey(ActiveAlertsLDAPConnectionPoolHealthCheck.formatAlertTypeForComparison(alertType))) continue;
                String message = UnboundIDDSMessages.ERR_ACTIVE_ALERTS_HEALTH_CHECK_DEGRADED_ALERT.get(GENERAL_MONITOR_ENTRY_DN, conn.getHostPort(), alertType);
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, message, null);
                throw new LDAPException(ResultCode.UNAVAILABLE, message);
            }
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ActiveAlertsLDAPConnectionPoolHealthCheck(invokeOnCreate=");
        buffer.append(this.invokeOnCreate);
        buffer.append(", invokeAfterAuthentication=");
        buffer.append(this.invokeAfterAuthentication);
        buffer.append(", invokeOnCheckout=");
        buffer.append(this.invokeOnCheckout);
        buffer.append(", invokeOnRelease=");
        buffer.append(this.invokeOnRelease);
        buffer.append(", invokeForBackgroundChecks=");
        buffer.append(this.invokeForBackgroundChecks);
        buffer.append(", invokeOnException=");
        buffer.append(this.invokeOnException);
        buffer.append(", maxResponseTimeMillis=");
        buffer.append(this.maxResponseTimeMillis);
        buffer.append(", ignoreAllDegradedAlertTypes=");
        buffer.append(this.ignoreAllDegradedAlertTypes);
        buffer.append(", ignoredDegradedAlertTypes=");
        ActiveAlertsLDAPConnectionPoolHealthCheck.appendAlertTypes(buffer, this.ignoredDegradedAlertTypes.values());
        buffer.append(", ignoredUnavailableAlertTypes=");
        ActiveAlertsLDAPConnectionPoolHealthCheck.appendAlertTypes(buffer, this.ignoredUnavailableAlertTypes.values());
        buffer.append(')');
    }

    private static void appendAlertTypes(@NotNull StringBuilder buffer, @NotNull Collection<String> names) {
        buffer.append("{ ");
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append('}');
    }
}

