/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class NodeDeprecationChecker {
    private static final Logger logger = LogManager.getLogger(NodeDeprecationChecker.class);
    private final ThreadPool threadPool;

    public NodeDeprecationChecker(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void check(Client client, ActionListener<List<DeprecationIssue>> listener) {
        NodesDeprecationCheckRequest nodeDepReq = new NodesDeprecationCheckRequest("_all");
        ClientHelper.executeAsyncWithOrigin((Client)client, (String)"deprecation", (ActionType)NodesDeprecationCheckAction.INSTANCE, (ActionRequest)nodeDepReq, (ActionListener)new ThreadedActionListener((Executor)this.threadPool.generic(), listener.delegateFailureAndWrap((l, response) -> {
            if (response.hasFailures()) {
                List failedNodeIds = response.failures().stream().map(failure -> failure.nodeId() + ": " + failure.getMessage()).collect(Collectors.toList());
                logger.warn("nodes failed to run deprecation checks: {}", failedNodeIds);
                for (FailedNodeException failure2 : response.failures()) {
                    logger.atWarn().withThrowable((Throwable)failure2).log("node {} failed to run deprecation checks", (Object)failure2.nodeId());
                }
            }
            l.onResponse(NodeDeprecationChecker.reduceToDeprecationIssues(response));
        })));
    }

    static List<DeprecationIssue> reduceToDeprecationIssues(NodesDeprecationCheckResponse response) {
        Collection<List<Tuple<DeprecationIssue, String>>> issuesToMerge = NodeDeprecationChecker.getDeprecationIssuesThatDifferOnlyByMeta(response.getNodes());
        Map<DeprecationIssue, List<String>> issueToListOfNodesMap = NodeDeprecationChecker.getMergedIssuesToNodesMap(issuesToMerge);
        return issueToListOfNodesMap.entrySet().stream().map(entry -> {
            DeprecationIssue issue = (DeprecationIssue)entry.getKey();
            String details = issue.getDetails() != null ? issue.getDetails() + " " : "";
            return new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), details + "(nodes impacted: " + String.valueOf(entry.getValue()) + ")", issue.isResolveDuringRollingUpgrade(), issue.getMeta());
        }).collect(Collectors.toList());
    }

    private static Collection<List<Tuple<DeprecationIssue, String>>> getDeprecationIssuesThatDifferOnlyByMeta(List<NodesDeprecationCheckAction.NodeResponse> nodeResponses) {
        HashMap<DeprecationIssue, List> issuesToMerge = new HashMap<DeprecationIssue, List>();
        for (NodesDeprecationCheckAction.NodeResponse resp : nodeResponses) {
            for (DeprecationIssue issue : resp.getDeprecationIssues()) {
                issuesToMerge.computeIfAbsent(new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), issue.getDetails(), issue.isResolveDuringRollingUpgrade(), null), key -> new ArrayList()).add(new Tuple((Object)issue, (Object)resp.getNode().getName()));
            }
        }
        return issuesToMerge.values();
    }

    private static Map<DeprecationIssue, List<String>> getMergedIssuesToNodesMap(Collection<List<Tuple<DeprecationIssue, String>>> issuesToMerge) {
        HashMap<DeprecationIssue, List<String>> issueToListOfNodesMap = new HashMap<DeprecationIssue, List<String>>();
        for (List<Tuple<DeprecationIssue, String>> similarIssues : issuesToMerge) {
            DeprecationIssue leastCommonDenominator = DeprecationIssue.getIntersectionOfRemovableSettings(similarIssues.stream().map(Tuple::v1).toList());
            issueToListOfNodesMap.computeIfAbsent(leastCommonDenominator, key -> new ArrayList()).addAll(similarIssues.stream().map(Tuple::v2).toList());
        }
        return issueToListOfNodesMap;
    }
}

