/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.simple;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;

public class SimpleInput
implements Input {
    public static final String TYPE = "simple";
    private final Payload payload;

    public SimpleInput(Payload payload) {
        this.payload = payload;
    }

    public String type() {
        return TYPE;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInput that = (SimpleInput)o;
        return this.payload.equals((Object)that.payload);
    }

    public int hashCode() {
        return this.payload.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.payload.toXContent(builder, params);
    }

    public static SimpleInput parse(String watchId, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] input for watch [{}]. expected an object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        Payload.Simple payload = new Payload.Simple(parser.map());
        return new SimpleInput((Payload)payload);
    }

    public static Builder builder(Payload payload) {
        return new Builder(payload);
    }

    public static class Builder
    implements Input.Builder<SimpleInput> {
        private final Payload payload;

        private Builder(Payload payload) {
            this.payload = payload;
        }

        public SimpleInput build() {
            return new SimpleInput(this.payload);
        }
    }

    public static class Result
    extends Input.Result {
        public Result(Payload payload) {
            super(SimpleInput.TYPE, payload);
        }

        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

