/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.io.Closeable;
import java.time.Clock;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.ilm.OperationModeUpdateTask;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.slm.SnapshotLifecycleTask;

public class SnapshotLifecycleService
implements Closeable,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(SnapshotLifecycleService.class);
    private static final String JOB_PATTERN_SUFFIX = "-\\d+$";
    private final ClusterService clusterService;
    private final Function<ProjectId, SnapshotLifecycleTask> taskProvider;
    private final Settings settings;
    private final Clock clock;
    private volatile boolean isMaster = false;
    private final ConcurrentMap<ProjectId, SnapshotLifecycleProjectState> projects = ConcurrentCollections.newConcurrentMap();

    public SnapshotLifecycleService(Settings settings, Function<ProjectId, SnapshotLifecycleTask> taskProvider, ClusterService clusterService, Clock clock) {
        this.settings = settings;
        this.taskProvider = taskProvider;
        this.clusterService = clusterService;
        this.clock = clock;
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean prevIsMaster = this.isMaster;
        boolean masterChanged = prevIsMaster != event.localNodeMaster();
        this.isMaster = event.localNodeMaster();
        for (ProjectMetadata metadata : event.state().metadata().projects().values()) {
            SnapshotLifecycleProjectState project = this.getOrCreateProjectState(metadata.id());
            if (masterChanged) {
                if (this.isMaster) {
                    project.scheduler.register((SchedulerEngine.Listener)project.snapshotTask);
                } else {
                    project.scheduler.unregister((SchedulerEngine.Listener)project.snapshotTask);
                    this.cancelSnapshotJobs(project);
                }
            }
            if (!this.isMaster) continue;
            if (SnapshotLifecycleService.slmStoppedOrStopping(metadata)) {
                if (!project.scheduler.scheduledJobIds().isEmpty()) {
                    this.cancelSnapshotJobs(project);
                }
                if (!SnapshotLifecycleService.slmStopping(metadata)) continue;
                this.submitUnbatchedTask("slm_operation_mode_update[stopped]", (ClusterStateUpdateTask)OperationModeUpdateTask.slmMode((OperationMode)OperationMode.STOPPED));
                continue;
            }
            this.scheduleSnapshotJobs(project, metadata);
            this.cleanupDeletedPolicies(project, metadata);
        }
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    SchedulerEngine getScheduler(ProjectId projectId) {
        SnapshotLifecycleProjectState project = (SnapshotLifecycleProjectState)this.projects.get(projectId);
        return project == null ? null : project.scheduler;
    }

    @Deprecated(forRemoval=true)
    static boolean slmStoppedOrStopping(ClusterState state) {
        OperationMode mode = LifecycleOperationMetadata.currentSLMMode((ClusterState)state);
        return OperationMode.STOPPING == mode || OperationMode.STOPPED == mode;
    }

    static boolean slmStoppedOrStopping(ProjectMetadata metadata) {
        OperationMode mode = LifecycleOperationMetadata.currentSLMMode((ProjectMetadata)metadata);
        return OperationMode.STOPPING == mode || OperationMode.STOPPED == mode;
    }

    static boolean slmStopping(ProjectMetadata metadata) {
        OperationMode mode = LifecycleOperationMetadata.currentSLMMode((ProjectMetadata)metadata);
        return OperationMode.STOPPING == mode;
    }

    private void scheduleSnapshotJobs(SnapshotLifecycleProjectState project, ProjectMetadata metadata) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)metadata.custom("snapshot_lifecycle");
        if (snapMeta != null) {
            snapMeta.getSnapshotConfigurations().values().forEach(config -> this.maybeScheduleSnapshot(project, (SnapshotLifecyclePolicyMetadata)config));
        }
    }

    private void cleanupDeletedPolicies(SnapshotLifecycleProjectState project, ProjectMetadata metadata) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)metadata.custom("snapshot_lifecycle");
        if (snapMeta != null) {
            Set policyJobIds = snapMeta.getSnapshotConfigurations().values().stream().map(SnapshotLifecycleService::getJobId).collect(Collectors.toSet());
            project.scheduledTasks.keySet().stream().filter(jobId -> !policyJobIds.contains(jobId)).forEach(jobId -> this.cancelScheduledSnapshot(project, (String)jobId));
        }
    }

    void maybeScheduleSnapshot(SnapshotLifecycleProjectState project, SnapshotLifecyclePolicyMetadata snapshotLifecyclePolicy) {
        if (!project.running.get()) {
            return;
        }
        String jobId = SnapshotLifecycleService.getJobId(snapshotLifecyclePolicy);
        Pattern existingJobPattern = Pattern.compile(snapshotLifecyclePolicy.getPolicy().getId() + JOB_PATTERN_SUFFIX);
        boolean existingJobsFoundAndCancelled = project.scheduledTasks.keySet().stream().filter(jId -> existingJobPattern.matcher((CharSequence)jId).matches()).filter(jId -> !jId.equals(jobId)).map(existingJobId -> {
            logger.debug("removing existing snapshot lifecycle job [{}] as it has been updated", existingJobId);
            project.scheduledTasks.remove(existingJobId);
            boolean existed = project.scheduler.remove(existingJobId);
            assert (existed) : "expected job for " + existingJobId + " to exist in scheduler";
            return existed;
        }).reduce(false, (a, b) -> a != false || b != false);
        project.scheduledTasks.computeIfAbsent(jobId, id -> {
            if (existingJobsFoundAndCancelled) {
                logger.info("rescheduling updated snapshot lifecycle job [{}]", (Object)jobId);
            } else {
                logger.info("scheduling snapshot lifecycle job [{}]", (Object)jobId);
            }
            SchedulerEngine.Job job = snapshotLifecyclePolicy.buildSchedulerJob(jobId);
            project.scheduler.add(job);
            return job;
        });
    }

    public static String getJobId(SnapshotLifecyclePolicyMetadata policyMeta) {
        return policyMeta.getPolicy().getId() + "-" + policyMeta.getVersion();
    }

    private void cancelSnapshotJobs(SnapshotLifecycleProjectState project) {
        logger.trace("cancelling all snapshot lifecycle jobs");
        project.scheduler.scheduledJobIds().forEach(arg_0 -> ((SchedulerEngine)project.scheduler).remove(arg_0));
        project.scheduledTasks.clear();
    }

    private void cancelScheduledSnapshot(SnapshotLifecycleProjectState project, String lifecycleJobId) {
        logger.debug("cancelling project [{}] snapshot lifecycle job [{}] as it no longer exists", (Object)project.projectId, (Object)lifecycleJobId);
        project.scheduledTasks.remove(lifecycleJobId);
        project.scheduler.remove(lifecycleJobId);
    }

    private SnapshotLifecycleProjectState getOrCreateProjectState(ProjectId projectId) {
        return this.projects.computeIfAbsent(projectId, id -> new SnapshotLifecycleProjectState(projectId, new SchedulerEngine(this.settings, this.clock), this.taskProvider.apply(projectId)));
    }

    @Deprecated(forRemoval=true)
    public static void validateRepositoryExists(String repository, ClusterState state) {
        if (RepositoriesMetadata.get((ClusterState)state).repository(repository) == null) {
            throw new IllegalArgumentException("no such repository [" + repository + "]");
        }
    }

    public static void validateMinimumInterval(SnapshotLifecyclePolicy lifecycle, ClusterState state) {
        TimeValue minimum = (TimeValue)LifecycleSettings.SLM_MINIMUM_INTERVAL_SETTING.get(state.metadata().settings());
        TimeValue next = lifecycle.calculateNextInterval(Clock.systemUTC());
        if (next.duration() > 0L && minimum.duration() > 0L && next.millis() < minimum.millis()) {
            throw new IllegalArgumentException("invalid schedule [" + lifecycle.getSchedule() + "]: schedule would be too frequent, executing more than every [" + minimum.getStringRep() + "]");
        }
    }

    @Override
    public void close() {
        this.projects.values().forEach(project -> {
            if (project.running.compareAndSet(true, false)) {
                project.scheduler.stop();
            }
        });
    }

    static class SnapshotLifecycleProjectState {
        final ProjectId projectId;
        final SchedulerEngine scheduler;
        final SnapshotLifecycleTask snapshotTask;
        final Map<String, SchedulerEngine.Job> scheduledTasks = ConcurrentCollections.newConcurrentMap();
        final AtomicBoolean running = new AtomicBoolean(true);

        SnapshotLifecycleProjectState(ProjectId projectId, SchedulerEngine scheduler, SnapshotLifecycleTask snapshotTask) {
            this.projectId = projectId;
            this.scheduler = scheduler;
            this.snapshotTask = snapshotTask;
        }
    }
}

