/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.embeddings;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingType;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;

public class JinaAIEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings {
    public static final String NAME = "jinaai_embeddings_service_settings";
    static final String EMBEDDING_TYPE = "embedding_type";
    private static final TransportVersion JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED = TransportVersion.fromName((String)"jina_ai_embedding_type_support_added");
    static final TransportVersion JINA_AI_EMBEDDING_DIMENSIONS_SUPPORT_ADDED = TransportVersion.fromName((String)"jina_ai_embedding_dimensions_support_added");
    private final JinaAIServiceSettings commonSettings;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final JinaAIEmbeddingType embeddingType;
    private final Boolean dimensionsSetByUser;

    public static JinaAIEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        Boolean dimensionsSetByUser;
        ValidationException validationException = new ValidationException();
        JinaAIServiceSettings commonServiceSettings = JinaAIServiceSettings.fromMap(map, context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dimensions = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        JinaAIEmbeddingType embeddingTypes = JinaAIEmbeddingsServiceSettings.parseEmbeddingType(map, validationException);
        if (context == ConfigurationParseContext.PERSISTENT) {
            dimensionsSetByUser = ServiceUtils.removeAsType(map, "dimensions_set_by_user", Boolean.class);
            if (dimensionsSetByUser == null) {
                dimensionsSetByUser = Boolean.FALSE;
            }
        } else {
            dimensionsSetByUser = dimensions != null;
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new JinaAIEmbeddingsServiceSettings(commonServiceSettings, similarity, dimensions, maxInputTokens, embeddingTypes, dimensionsSetByUser);
    }

    static JinaAIEmbeddingType parseEmbeddingType(Map<String, Object> map, ValidationException validationException) {
        return Objects.requireNonNullElse(ServiceUtils.extractOptionalEnum(map, EMBEDDING_TYPE, "service_settings", JinaAIEmbeddingType::fromString, EnumSet.allOf(JinaAIEmbeddingType.class), validationException), JinaAIEmbeddingType.FLOAT);
    }

    public JinaAIEmbeddingsServiceSettings(JinaAIServiceSettings commonSettings, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, @Nullable JinaAIEmbeddingType embeddingType, Boolean dimensionsSetByUser) {
        this.commonSettings = commonSettings;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.embeddingType = embeddingType != null ? embeddingType : JinaAIEmbeddingType.FLOAT;
        this.dimensionsSetByUser = Objects.requireNonNull(dimensionsSetByUser);
    }

    public JinaAIEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new JinaAIServiceSettings(in);
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
        this.embeddingType = in.getTransportVersion().supports(JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED) ? Objects.requireNonNullElse((JinaAIEmbeddingType)in.readOptionalEnum(JinaAIEmbeddingType.class), JinaAIEmbeddingType.FLOAT) : JinaAIEmbeddingType.FLOAT;
        this.dimensionsSetByUser = in.getTransportVersion().supports(JINA_AI_EMBEDDING_DIMENSIONS_SUPPORT_ADDED) ? Boolean.valueOf(in.readBoolean()) : Boolean.valueOf(false);
    }

    public JinaAIServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    public JinaAIEmbeddingType getEmbeddingType() {
        return this.embeddingType;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return this.embeddingType == null ? DenseVectorFieldMapper.ElementType.FLOAT : this.embeddingType.toElementType();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        if (this.dimensionsSetByUser != null) {
            builder.field("dimensions_set_by_user", this.dimensionsSetByUser);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.commonSettings.toXContentFragmentOfExposedFields(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.embeddingType != null) {
            builder.field(EMBEDDING_TYPE, (Enum)this.embeddingType);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
        if (out.getTransportVersion().supports(JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED)) {
            out.writeOptionalEnum((Enum)JinaAIEmbeddingType.translateToVersion(this.embeddingType, out.getTransportVersion()));
        }
        if (out.getTransportVersion().supports(JINA_AI_EMBEDDING_DIMENSIONS_SUPPORT_ADDED)) {
            out.writeBoolean(this.dimensionsSetByUser.booleanValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JinaAIEmbeddingsServiceSettings that = (JinaAIEmbeddingsServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals((Object)this.embeddingType, (Object)that.embeddingType) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonSettings, this.similarity, this.dimensions, this.maxInputTokens, this.embeddingType, this.dimensionsSetByUser});
    }
}

