/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.script.field.Field;

public class SourceMapField
implements Field<Object> {
    protected String path;
    protected Supplier<Map<String, Object>> rootSupplier;
    protected Map<String, Object> container;
    protected String leaf;
    protected static final Object MISSING = new Object();

    public SourceMapField(String path, Supplier<Map<String, Object>> rootSupplier) {
        this.path = path;
        this.rootSupplier = rootSupplier;
        this.resolveDepthFlat();
    }

    @Override
    public String getName() {
        return this.path;
    }

    public boolean exists() {
        return this.leaf != null && this.container.containsKey(this.leaf);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.leaf == null) {
            return 0;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return 0;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.size();
        }
        return 1;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.leaf == null) {
            return Collections.emptyIterator();
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return Collections.emptyIterator();
        }
        if (value instanceof List) {
            List list = (List)value;
            return this.getListIterator(list);
        }
        return Collections.singleton(value).iterator();
    }

    protected Iterator<Object> getListIterator(List<?> list) {
        return Collections.unmodifiableList(list).iterator();
    }

    public Object get(Object defaultValue) {
        if (this.leaf == null) {
            return defaultValue;
        }
        return this.container.getOrDefault(this.leaf, defaultValue);
    }

    public Object get(int index, Object defaultValue) {
        if (this.leaf == null) {
            return defaultValue;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value instanceof List) {
            List list = (List)value;
            if (index < list.size()) {
                return list.get(index);
            }
        } else if (value != MISSING && index == 0) {
            return value;
        }
        return defaultValue;
    }

    public boolean hasValue(Predicate<Object> predicate) {
        if (this.leaf == null) {
            return false;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return false;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().anyMatch(predicate);
        }
        return predicate.test(value);
    }

    protected void setPath(String path) {
        this.path = path;
        this.leaf = null;
        this.container = null;
    }

    protected final void resolveDepthFlat() {
        this.container = this.rootSupplier.get();
        int index = this.path.indexOf(46);
        int lastIndex = 0;
        while (index != -1) {
            String segment = this.path.substring(lastIndex, index);
            Object value = this.container.get(segment);
            if (value instanceof Map) {
                Map map;
                this.container = map = (Map)value;
                lastIndex = index + 1;
                index = this.path.indexOf(46, lastIndex);
                continue;
            }
            String rest = this.path.substring(lastIndex);
            this.leaf = this.container.containsKey(rest) ? rest : null;
            return;
        }
        this.leaf = this.path.substring(lastIndex);
    }
}

